/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class NewScanParameterPage
extends WizardPage {
    private final List<String> parameterNames;
    private Button enableExcludedParameters;
    private ListViewer excludedParameterList;
    private Text parameterNameText;
    private Button addParameterButton;
    private Button removeParameterButton;

    protected NewScanParameterPage(Collection<String> collection) {
        super("Parameters");
        this.setTitle("Parameters");
        this.setDescription("Add names of parameters to avoid fuzzing during scan");
        this.parameterNames = new ArrayList<String>(collection);
    }

    public Set<String> getExcludedParameterNames() {
        if (this.enableExcludedParameters.getSelection()) {
            return Collections.unmodifiableSet(new HashSet<String>(this.parameterNames));
        }
        return Collections.emptySet();
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        Group group = this.createGroupControl(composite2);
        this.createEnableButton((Composite)group);
        this.createParameterExcludeList((Composite)group);
        this.createAddRemoveWidget((Composite)group);
        this.updatePage();
        this.setControl((Control)composite2);
    }

    private Group createGroupControl(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText("Exclude Parameters");
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 15;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        return group;
    }

    private void createEnableButton(Composite composite) {
        this.enableExcludedParameters = new Button(composite, 32);
        this.enableExcludedParameters.setText("Exclude listed parameters from scan");
        this.enableExcludedParameters.setSelection(true);
        this.enableExcludedParameters.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.enableExcludedParameters.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (NewScanParameterPage.this.excludedParameterList != null) {
                    NewScanParameterPage.this.updatePage();
                }
            }
        });
    }

    private void createParameterExcludeList(Composite composite) {
        this.excludedParameterList = new ListViewer(composite, 2562);
        this.excludedParameterList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        GridData gridData = new GridData(4, 4, true, true);
        this.excludedParameterList.getList().setLayoutData((Object)gridData);
        this.excludedParameterList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                NewScanParameterPage.this.updatePage();
            }
        });
        this.excludedParameterList.setInput((Object)this.parameterNames.toArray());
    }

    private void createAddRemoveWidget(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new RowLayout());
        composite2.setLayoutData((Object)new GridData(4, 4, true, false));
        this.parameterNameText = new Text(composite2, 2052);
        this.parameterNameText.setMessage("Enter name of parameter to exclude");
        this.addParameterButton = new Button(composite2, 8);
        this.addParameterButton.setText("Add");
        this.removeParameterButton = new Button(composite2, 8);
        this.removeParameterButton.setText("Remove");
        this.parameterNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewScanParameterPage.this.updatePage();
            }
        });
        this.addParameterButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NewScanParameterPage.this.handleAddParameter();
            }
        });
        this.removeParameterButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NewScanParameterPage.this.handleRemoveParameter();
            }
        });
    }

    private void handleAddParameter() {
        String string = this.parameterNameText.getText();
        if (!this.parameterNames.contains(string)) {
            this.parameterNames.add(string.toLowerCase());
            this.excludedParameterList.setInput((Object)this.parameterNames.toArray());
        }
        this.parameterNameText.setText("");
    }

    private void handleRemoveParameter() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.excludedParameterList.getSelection();
        Object[] objectArray = iStructuredSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof String) {
                this.parameterNames.remove(object);
            }
            ++n2;
        }
        this.excludedParameterList.setInput((Object)this.parameterNames.toArray());
        this.updatePage();
    }

    private void updatePage() {
        if (this.enableExcludedParameters.getSelection()) {
            this.excludedParameterList.getList().setEnabled(true);
            this.setAddRemoveWidgetEnabled();
        } else {
            this.excludedParameterList.getList().setEnabled(false);
            this.setAddRemoveWidgetDisabled();
        }
    }

    private void setAddRemoveWidgetDisabled() {
        this.parameterNameText.setEnabled(false);
        this.addParameterButton.setEnabled(false);
        this.removeParameterButton.setEnabled(false);
    }

    private void setAddRemoveWidgetEnabled() {
        this.parameterNameText.setEnabled(true);
        this.setAddRemoveButtonsEnabledForState();
    }

    private void setAddRemoveButtonsEnabledForState() {
        this.addParameterButton.setEnabled(!this.parameterNameText.getText().isEmpty());
        this.removeParameterButton.setEnabled(!this.excludedParameterList.getSelection().isEmpty());
    }
}

