/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.wizards;

import com.subgraph.vega.api.model.scope.ITargetScope;
import com.subgraph.vega.api.model.web.IWebHost;
import com.subgraph.vega.api.model.web.IWebModelVisitor;
import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.api.model.web.IWebResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public class InScopeWebVisitor
implements IWebModelVisitor {
    private final ITargetScope scope;
    private final Set<URI> scopeURIs;

    InScopeWebVisitor(ITargetScope iTargetScope) {
        this.scope = iTargetScope;
        this.scopeURIs = new TreeSet<URI>();
    }

    public Collection<URI> getScopeURIs() {
        return Collections.unmodifiableCollection(new ArrayList<URI>(this.scopeURIs));
    }

    public void visit(IWebHost iWebHost) {
        URI uRI = iWebHost.getUri();
        if (this.scope.filter(uRI)) {
            this.scopeURIs.add(uRI);
        }
    }

    public void visit(IWebPath iWebPath) {
        URI uRI = iWebPath.getUri();
        if (this.scope.filter(uRI)) {
            this.scopeURIs.add(uRI);
        }
    }

    public void visit(IWebResponse iWebResponse) {
    }
}

