/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.scope;

import com.subgraph.vega.api.model.scope.ITargetScope;
import com.subgraph.vega.ui.util.images.ImageCache;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class RemovableItemWidget
extends Composite {
    private static final String REMOVE_ICON = "icons/remove.png";
    private static final ImageCache imageCache = new ImageCache("com.subgraph.vega.ui.scanner");
    protected final Text addText;
    protected final Button addButton;
    private final TableViewer tableViewer;
    protected ITargetScope currentScope;

    public RemovableItemWidget(Composite composite, String string, StructuredViewer structuredViewer) {
        super(composite, 0);
        this.setLayout((Layout)new FillLayout());
        Group group = new Group((Composite)this, 0);
        group.setText(string);
        group.setLayout((Layout)new GridLayout(2, false));
        this.tableViewer = this.createTableViewer((Composite)group);
        this.addText = this.createText((Composite)group, this.createModifyListener());
        this.addButton = this.createAddButton((Composite)group, (SelectionListener)this.createSelectionListener());
        this.currentScope = this.getScopeFromSelection(structuredViewer.getSelection());
        structuredViewer.addSelectionChangedListener(this.createSelectionChangedListener());
        this.reloadInput();
    }

    protected void reloadInput() {
        this.tableViewer.setInput((Object)this.getTableInput());
        this.tableViewer.getTable().getParent().layout();
    }

    private ISelectionChangedListener createSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                RemovableItemWidget.this.currentScope = RemovableItemWidget.this.getScopeFromSelection(selectionChangedEvent.getSelection());
                RemovableItemWidget.this.reloadInput();
            }
        };
    }

    private ITargetScope getScopeFromSelection(ISelection iSelection) {
        if (!(iSelection instanceof StructuredSelection)) {
            return null;
        }
        Object object = ((StructuredSelection)iSelection).getFirstElement();
        if (!(object instanceof ITargetScope)) {
            return null;
        }
        return (ITargetScope)object;
    }

    private ModifyListener createModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                RemovableItemWidget.this.addButton.setEnabled(RemovableItemWidget.this.verifyText(RemovableItemWidget.this.addText.getText()));
            }
        };
    }

    private SelectionListener createTextSelectionListener() {
        return new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                if (RemovableItemWidget.this.handleInput(RemovableItemWidget.this.addText.getText())) {
                    RemovableItemWidget.this.addText.setText("");
                    RemovableItemWidget.this.reloadInput();
                }
            }
        };
    }

    private SelectionAdapter createSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (RemovableItemWidget.this.handleInput(RemovableItemWidget.this.addText.getText())) {
                    RemovableItemWidget.this.addText.setText("");
                    RemovableItemWidget.this.reloadInput();
                }
            }
        };
    }

    abstract Object[] getTableInput();

    abstract boolean verifyText(String var1);

    abstract boolean handleInput(String var1);

    abstract boolean handleRemoveElement(Object var1);

    private Text createText(Composite composite, ModifyListener modifyListener) {
        Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text.addModifyListener(modifyListener);
        text.addSelectionListener(this.createTextSelectionListener());
        text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 4) {
                    traverseEvent.doit = false;
                }
            }
        });
        return text;
    }

    private Button createAddButton(Composite composite, SelectionListener selectionListener) {
        Button button = new Button(composite, 0);
        button.setText("Add");
        button.setEnabled(false);
        button.addSelectionListener(selectionListener);
        return button;
    }

    private TableViewer createTableViewer(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        final TableViewer tableViewer = new TableViewer(composite2, 2560);
        Table table = tableViewer.getTable();
        table.setHeaderVisible(false);
        table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                RemovableItemWidget.this.handleTableMouseDown(event, tableViewer);
            }
        });
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        this.createDataColumn(tableViewer, tableColumnLayout);
        this.createRemoveColumn(tableViewer, tableColumnLayout);
        composite2.setLayout((Layout)tableColumnLayout);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 80;
        composite2.setLayoutData((Object)gridData);
        tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        return tableViewer;
    }

    private void handleTableMouseDown(Event event, TableViewer tableViewer) {
        Table table = tableViewer.getTable();
        Rectangle rectangle = table.getClientArea();
        Point point = new Point(event.x, event.y);
        int n = table.getTopIndex();
        while (n < table.getItemCount()) {
            TableItem tableItem = table.getItem(n);
            Rectangle rectangle2 = tableItem.getBounds(1);
            if (!rectangle2.intersects(rectangle)) {
                return;
            }
            if (rectangle2.contains(point) && this.handleRemoveElement(tableViewer.getElementAt(n))) {
                this.reloadInput();
            }
            ++n;
        }
    }

    private void createDataColumn(TableViewer tableViewer, TableColumnLayout tableColumnLayout) {
        TableViewerColumn tableViewerColumn = this.createTableColumn(tableViewer, tableColumnLayout, 16384, (ColumnLayoutData)new ColumnWeightData(100));
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
    }

    private void createRemoveColumn(TableViewer tableViewer, TableColumnLayout tableColumnLayout) {
        TableViewerColumn tableViewerColumn = this.createTableColumn(tableViewer, tableColumnLayout, 0x1000000, (ColumnLayoutData)new ColumnPixelData(20, false, true));
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object object) {
                return null;
            }

            public Image getImage(Object object) {
                return imageCache.get(RemovableItemWidget.REMOVE_ICON);
            }
        });
    }

    private TableViewerColumn createTableColumn(TableViewer tableViewer, TableColumnLayout tableColumnLayout, int n, ColumnLayoutData columnLayoutData) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, n);
        TableColumn tableColumn = tableViewerColumn.getColumn();
        tableColumn.setMoveable(false);
        tableColumn.setResizable(false);
        tableColumnLayout.setColumnData((Widget)tableColumn, columnLayoutData);
        return tableViewerColumn;
    }
}

