/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.dashboard;

import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.ui.scanner.dashboard.AlertItemRow;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AlertSeverityCell
extends Composite {
    private final Label imageLabel;
    private final Label labelLabel;
    private final Label countLabel;
    private final Image image;
    private int totalCount = 0;
    private Map<String, AlertItemRow> alertTitleToItem = new HashMap<String, AlertItemRow>();

    AlertSeverityCell(Composite composite, Color color, Image image, Image image2, String string) {
        super(composite, 0);
        this.image = image;
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.verticalSpacing = 2;
        this.setLayout((Layout)gridLayout);
        this.imageLabel = new Label((Composite)this, 0);
        this.imageLabel.setImage(image2);
        this.imageLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.imageLabel.setBackground(color);
        this.labelLabel = new Label((Composite)this, 0);
        this.labelLabel.setText(string);
        this.labelLabel.setFont(JFaceResources.getBannerFont());
        this.setLabelForegroundGrey(this.labelLabel);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.labelLabel.setLayoutData((Object)gridData);
        this.labelLabel.setBackground(color);
        this.countLabel = new Label((Composite)this, 16384);
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.widthHint = 85;
        this.countLabel.setLayoutData((Object)gridData);
        this.countLabel.setText("(None found)");
        this.countLabel.setBackground(color);
        this.setLabelForegroundGrey(this.countLabel);
        Composite composite2 = new Composite((Composite)this, 0);
        composite2.setBackground(color);
        gridData = new GridData(4, 4, true, false);
        gridData.heightHint = 5;
        gridData.horizontalSpan = 3;
        composite2.setLayoutData((Object)gridData);
    }

    private void setLabelForegroundGrey(Label label) {
        if (!label.isDisposed()) {
            label.setData("saved-foreground", (Object)label.getForeground());
            label.setForeground(this.getDisplay().getSystemColor(15));
        }
    }

    private void restoreLabelForeground(Label label) {
        Object object = label.getData("saved-foreground");
        if (object instanceof Color && !label.isDisposed()) {
            label.setForeground((Color)object);
        }
    }

    void addAlert(IScanAlert iScanAlert) {
        if (this.isDisposed()) {
            return;
        }
        this.incrementTotalCount();
        String string = iScanAlert.getTitle();
        if (!this.alertTitleToItem.containsKey(string)) {
            this.alertTitleToItem.put(string, this.createAlertItemRow(string));
            this.getParent().layout();
        }
        AlertItemRow alertItemRow = this.alertTitleToItem.get(string);
        alertItemRow.incrementCount();
    }

    private AlertItemRow createAlertItemRow(String string) {
        AlertItemRow alertItemRow = new AlertItemRow(this, string);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        gridData.horizontalIndent = 15;
        alertItemRow.setLayoutData(gridData);
        return alertItemRow;
    }

    private void incrementTotalCount() {
        if (this.totalCount == 0) {
            if (!this.imageLabel.isDisposed()) {
                this.imageLabel.setImage(this.image);
            }
            this.restoreLabelForeground(this.labelLabel);
            this.restoreLabelForeground(this.countLabel);
        }
        ++this.totalCount;
        if (!this.countLabel.isDisposed()) {
            this.countLabel.setText("(" + Integer.toString(this.totalCount) + " found)");
        }
    }
}

