/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.alerts.tree;

import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.ui.scanner.alerts.IAlertTreeNode;
import com.subgraph.vega.ui.scanner.alerts.tree.AbstractAlertTreeNode;
import com.subgraph.vega.ui.scanner.alerts.tree.AlertScanNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AlertTree
extends AbstractAlertTreeNode {
    private final IWorkspace workspace;

    public AlertTree(IWorkspace iWorkspace) {
        super(null);
        this.workspace = iWorkspace;
    }

    public synchronized AlertScanNode addScan(IScanInstance iScanInstance) {
        if (iScanInstance.getScanId() == -1L && iScanInstance.getAllAlerts().size() == 0) {
            return null;
        }
        AlertScanNode alertScanNode = this.getScanNode(iScanInstance.getScanId());
        if (alertScanNode.getScanInstance() == null) {
            alertScanNode.setScanInstance(iScanInstance);
        }
        return alertScanNode;
    }

    @Override
    public String getKey() {
        return "";
    }

    public synchronized AlertScanNode getScanNode(long l) {
        String string = Long.toString(l);
        AlertScanNode alertScanNode = (AlertScanNode)this.nodeMap.get(string);
        if (alertScanNode == null) {
            alertScanNode = new AlertScanNode(this, l, this.workspace);
            if (l == -1L) {
                alertScanNode.setScanInstance(this.workspace.getScanAlertRepository().getProxyScanInstance());
            }
            this.nodeMap.put(string, alertScanNode);
        }
        return alertScanNode;
    }

    @Override
    public String getLabel() {
        return "[root]";
    }

    @Override
    protected AbstractAlertTreeNode createNodeForAlert(IScanAlert iScanAlert) {
        return this.getScanNode(iScanAlert.getScanId());
    }

    @Override
    protected String createKeyForAlert(IScanAlert iScanAlert) {
        return Long.toString(iScanAlert.getScanId());
    }

    public void removeAlerts(Collection<IScanAlert> collection) {
        for (IScanAlert iScanAlert : collection) {
            this.removeAlert(iScanAlert);
        }
    }

    public synchronized void removeScan(IScanInstance iScanInstance) {
        String string = Long.toString(iScanInstance.getScanId());
        AlertScanNode alertScanNode = (AlertScanNode)this.nodeMap.remove(string);
        if (alertScanNode != null) {
            alertScanNode.remove();
        }
    }

    public synchronized List<AlertScanNode> getScanNodes() {
        ArrayList<AlertScanNode> arrayList = new ArrayList<AlertScanNode>();
        for (IAlertTreeNode iAlertTreeNode : this.nodeMap.values()) {
            arrayList.add((AlertScanNode)iAlertTreeNode);
        }
        return arrayList;
    }

    @Override
    public synchronized void removeNode(String string) {
        AlertScanNode alertScanNode = (AlertScanNode)this.nodeMap.get(string);
        if (alertScanNode != null && alertScanNode.getScanInstance().isActive()) {
            return;
        }
        this.nodeMap.remove(string);
    }
}

