/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.alerts;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.WorkspaceCloseEvent;
import com.subgraph.vega.api.model.WorkspaceOpenEvent;
import com.subgraph.vega.api.model.WorkspaceResetEvent;
import com.subgraph.vega.ui.scanner.alerts.ScanAlertView;
import com.subgraph.vega.ui.scanner.alerts.ScopeTracker;

public class WorkspaceTracker
implements IEventHandler {
    private final ScanAlertView alertView;
    private final ScopeTracker scopeTracker;

    static WorkspaceTracker create(IModel iModel, ScanAlertView scanAlertView, ScopeTracker scopeTracker) {
        WorkspaceTracker workspaceTracker = new WorkspaceTracker(scanAlertView, scopeTracker);
        IWorkspace iWorkspace = iModel.addWorkspaceListener((IEventHandler)workspaceTracker);
        workspaceTracker.setCurrentWorkspace(iWorkspace);
        return workspaceTracker;
    }

    private WorkspaceTracker(ScanAlertView scanAlertView, ScopeTracker scopeTracker) {
        this.alertView = scanAlertView;
        this.scopeTracker = scopeTracker;
    }

    private void setCurrentWorkspace(IWorkspace iWorkspace) {
        this.alertView.workspaceChanged(iWorkspace);
        this.scopeTracker.workspaceChanged(iWorkspace);
    }

    public void handleEvent(IEvent iEvent) {
        if (iEvent instanceof WorkspaceOpenEvent) {
            this.setCurrentWorkspace(((WorkspaceOpenEvent)iEvent).getWorkspace());
        } else if (iEvent instanceof WorkspaceCloseEvent) {
            this.setCurrentWorkspace(null);
        } else if (iEvent instanceof WorkspaceResetEvent) {
            this.setCurrentWorkspace(null);
            this.setCurrentWorkspace(((WorkspaceResetEvent)iEvent).getWorkspace());
        }
    }
}

