/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.alerts;

import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.ui.scanner.alerts.AlertTreeContentProvider;
import com.subgraph.vega.ui.scanner.alerts.IAlertTreeNode;
import com.subgraph.vega.ui.scanner.alerts.tree.AlertScanNode;
import com.subgraph.vega.ui.util.images.ImageCache;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class AlertTreeLabelProvider
extends LabelProvider {
    private static final String ALERT_ITEM = "icons/alert_item.png";
    private final ImageCache imageCache = new ImageCache("com.subgraph.vega.ui.scanner");
    private final AlertTreeContentProvider contentProvider;

    public AlertTreeLabelProvider(AlertTreeContentProvider alertTreeContentProvider) {
        this.contentProvider = alertTreeContentProvider;
    }

    public void dispose() {
        this.imageCache.dispose();
        super.dispose();
    }

    public String getText(Object object) {
        if (object instanceof IAlertTreeNode) {
            IAlertTreeNode iAlertTreeNode = (IAlertTreeNode)object;
            int n = iAlertTreeNode.getAlertCount();
            if (n <= 1) {
                return iAlertTreeNode.getLabel();
            }
            return String.valueOf(iAlertTreeNode.getLabel()) + " (" + n + ")";
        }
        if (object instanceof IScanAlert) {
            return ((IScanAlert)object).getResource();
        }
        return "???";
    }

    public Image getImage(Object object) {
        if (object instanceof AlertScanNode) {
            AlertScanNode alertScanNode = (AlertScanNode)object;
            if (alertScanNode.getScanInstance().isActive()) {
                boolean bl = this.contentProvider.isBlinkStateActive();
                if (bl) {
                    return this.imageCache.get(alertScanNode.getImage());
                }
                return this.imageCache.getDisabled(alertScanNode.getImage());
            }
            return this.imageCache.get(alertScanNode.getImage());
        }
        if (object instanceof IAlertTreeNode) {
            String string = ((IAlertTreeNode)object).getImage();
            if (string != null) {
                return this.imageCache.get(string);
            }
        } else if (object instanceof IScanAlert) {
            return this.imageCache.get(ALERT_ITEM);
        }
        return null;
    }
}

