/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner;

import com.subgraph.vega.api.model.scope.ITargetScope;
import com.subgraph.vega.api.scanner.IScan;
import com.subgraph.vega.api.scanner.IScanProbeResult;
import java.net.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ScanProbeTask
implements Runnable {
    private final Shell shell;
    private final IScan scan;
    private volatile boolean cancelScan;

    ScanProbeTask(Shell shell, IScan iScan) {
        this.shell = shell;
        this.scan = iScan;
    }

    @Override
    public void run() {
        ITargetScope iTargetScope = this.scan.getConfig().getScanTargetScope();
        for (URI uRI : iTargetScope.getScopeURIs()) {
            if (this.cancelScan) {
                this.scan.stopScan();
                return;
            }
            this.processTargetURI(uRI);
        }
        if (this.cancelScan) {
            this.scan.stopScan();
        } else {
            this.scan.startScan();
        }
    }

    private void processTargetURI(final URI uRI) {
        final IScanProbeResult iScanProbeResult = this.scan.probeTargetUri(uRI);
        this.shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!ScanProbeTask.this.processProbeResult(uRI, iScanProbeResult)) {
                    ScanProbeTask.this.cancelScan = true;
                }
            }
        });
    }

    private boolean processProbeResult(URI uRI, IScanProbeResult iScanProbeResult) {
        if (iScanProbeResult.getProbeResultType() == IScanProbeResult.ProbeResultType.PROBE_CONNECT_FAILED) {
            MessageDialog.openError((Shell)this.shell, (String)"Failed to connect to target", (String)iScanProbeResult.getFailureMessage());
            return false;
        }
        if (iScanProbeResult.getProbeResultType() == IScanProbeResult.ProbeResultType.PROBE_REDIRECT) {
            String string;
            boolean bl;
            URI uRI2 = iScanProbeResult.getRedirectTarget();
            if (!this.isTrivialRedirect(uRI, uRI2) && !(bl = MessageDialog.openQuestion((Shell)this.shell, (String)"Follow Redirect?", (String)(string = "Target address " + uRI + " redirects to address " + uRI2 + "\n\n" + "Would you like to add " + uRI2 + " to the scope?")))) {
                return false;
            }
            this.scan.getConfig().getScanTargetScope().addScopeURI(uRI2);
            return true;
        }
        if (iScanProbeResult.getProbeResultType() == IScanProbeResult.ProbeResultType.PROBE_REDIRECT_FAILED) {
            MessageDialog.openError((Shell)this.shell, (String)"Redirect failure", (String)iScanProbeResult.getFailureMessage());
            return false;
        }
        return true;
    }

    private boolean isTrivialRedirect(URI uRI, URI uRI2) {
        String string = uRI.toString();
        if (string.endsWith("/")) {
            return false;
        }
        return uRI2.toString().equals(String.valueOf(string) + "/");
    }
}

