/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner;

import com.subgraph.vega.api.model.scope.ITargetScope;
import com.subgraph.vega.api.scanner.IScan;
import com.subgraph.vega.api.scanner.IScanner;
import com.subgraph.vega.api.scanner.IScannerConfig;
import com.subgraph.vega.ui.scanner.Activator;
import com.subgraph.vega.ui.scanner.ScanProbeTask;
import com.subgraph.vega.ui.scanner.wizards.NewScanWizard;
import com.subgraph.vega.ui.scanner.wizards.NewWizardDialog;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;

public class ScanExecutor {
    public String runScan(Shell shell, String string) {
        IScanner iScanner = Activator.getDefault().getScanner();
        IScan iScan = iScanner.createScan();
        Collection collection = Activator.getDefault().getModel().getCurrentWorkspace().getIdentityModel().getAllIdentities();
        NewScanWizard newScanWizard = new NewScanWizard(string, collection, iScan.getModuleList(), iScan.getConfig().getDefaultExcludedParameterNames());
        NewWizardDialog newWizardDialog = new NewWizardDialog(shell, (IWizard)newScanWizard);
        if (newWizardDialog.open() == 0) {
            return this.maybeLaunchScanFromWizard(shell, newScanWizard, iScanner, iScan);
        }
        iScan.stopScan();
        return null;
    }

    private String maybeLaunchScanFromWizard(Shell shell, NewScanWizard newScanWizard, IScanner iScanner, IScan iScan) {
        ITargetScope iTargetScope = newScanWizard.getScanTargetScope();
        if (iTargetScope == null) {
            return null;
        }
        IScannerConfig iScannerConfig = iScan.getConfig();
        iScannerConfig.setScanTargetScope(iTargetScope);
        iScannerConfig.setUserAgent("UserAgent");
        iScannerConfig.setCookieList(this.getCookieListForScope(newScanWizard.getCookieStringList(), iTargetScope));
        iScannerConfig.setScanIdentity(newScanWizard.getScanIdentity());
        iScannerConfig.setExcludedParameterNames(newScanWizard.getExcludedParameterNames());
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        iScannerConfig.setLogAllRequests(iPreferenceStore.getBoolean("LogAllRequests"));
        iScannerConfig.setDisplayDebugOutput(iPreferenceStore.getBoolean("DisplayDebugOutput"));
        iScannerConfig.setMaxRequestsPerSecond(iPreferenceStore.getInt("MaxRequestsPerSecond"));
        iScannerConfig.setMaxDescendants(iPreferenceStore.getInt("MaxScanDescendants"));
        iScannerConfig.setMaxChildren(iPreferenceStore.getInt("MaxScanChildren"));
        iScannerConfig.setMaxDepth(iPreferenceStore.getInt("MaxScanDepth"));
        iScannerConfig.setMaxDuplicatePaths(iPreferenceStore.getInt("MaxScanDuplicatePaths"));
        iScannerConfig.setMaxResponseKilobytes(iPreferenceStore.getInt("MaxResponseLength"));
        Thread thread = new Thread(new ScanProbeTask(shell, iScan));
        thread.start();
        return newScanWizard.getTargetField();
    }

    private List<Cookie> getCookieListForScope(List<String> list, ITargetScope iTargetScope) {
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
        for (URI uRI : iTargetScope.getScopeURIs()) {
            arrayList.addAll(this.getCookieList(list, uRI));
        }
        return arrayList;
    }

    private List<Cookie> getCookieList(List<String> list, URI uRI) {
        if (list.size() != 0) {
            ArrayList<Cookie> arrayList = new ArrayList<Cookie>(list.size());
            for (String string : list) {
                List<HttpCookie> list2 = HttpCookie.parse(string);
                for (HttpCookie httpCookie : list2) {
                    BasicClientCookie basicClientCookie = new BasicClientCookie(httpCookie.getName(), httpCookie.getValue());
                    basicClientCookie.setComment(httpCookie.getComment());
                    if (httpCookie.getDomain() != null) {
                        basicClientCookie.setDomain(httpCookie.getDomain());
                    } else {
                        basicClientCookie.setDomain(uRI.getHost());
                    }
                    long l = httpCookie.getMaxAge();
                    if (l > 0L) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.add(13, (int)l);
                        basicClientCookie.setExpiryDate(calendar.getTime());
                    }
                    basicClientCookie.setPath(httpCookie.getPath());
                    basicClientCookie.setSecure(httpCookie.getSecure());
                    basicClientCookie.setVersion(httpCookie.getVersion());
                    arrayList.add((Cookie)basicClientCookie);
                }
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

