/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.sslprobe;

import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.internal.sslprobe.CertificateAnalyzer;
import com.subgraph.vega.internal.sslprobe.SSLScanTaskManager;
import com.subgraph.vega.internal.sslprobe.SSLServerScanResult;
import com.subgraph.vega.internal.sslprobe.SSLv2CipherSpec;
import com.subgraph.vega.internal.sslprobe.TLSCipherSpec;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SSLProbe
implements Runnable {
    private final int NTHREADS = 10;
    private final ExecutorService executor = Executors.newFixedThreadPool(10);
    private SSLServerScanResult result;
    private final String host;
    private final int port;
    private final IScanInstance scanInstance;
    private final String hostString;
    private final Logger logger = Logger.getLogger("scanner");

    public SSLProbe(IScanInstance iScanInstance, String string, int n, String string2) {
        this.host = string;
        this.port = n;
        this.scanInstance = iScanInstance;
        this.hostString = string2;
    }

    @Override
    public void run() {
        SSLScanTaskManager sSLScanTaskManager = new SSLScanTaskManager(this.executor);
        try {
            this.result = sSLScanTaskManager.scanServer(this.host, this.port);
            this.summarizeResults(this.result);
            sSLScanTaskManager.shutdown();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void summarizeResults(SSLServerScanResult sSLServerScanResult) {
        IScanAlert iScanAlert;
        String string = "SSL Server Configuration Probe\n";
        string = String.valueOf(string) + "Target: " + sSLServerScanResult.getTargetHost() + ":" + sSLServerScanResult.getTargetPort() + "\n\n";
        if (sSLServerScanResult.getTLSProbeFailure()) {
            string = String.valueOf(string) + "Scan Failed (" + sSLServerScanResult.getErrorMessage() + ")\n";
        }
        string = String.valueOf(string) + "SSL/TLS Version Enumeration\n";
        string = String.valueOf(string) + "---------------------------------------------------------\n";
        boolean bl = sSLServerScanResult.isSet(SSLServerScanResult.Flag.SSLV2);
        if (bl) {
            iScanAlert = this.scanInstance.createAlert("ssl-v2-support", String.valueOf(this.host) + "-sslv2");
            iScanAlert.setDiscretionaryHostname(this.hostString);
            iScanAlert.setResource(this.hostString);
            this.scanInstance.addAlert(iScanAlert);
            string = String.valueOf(string) + "  [ BAD ]  SSL v2 Support: " + bl + "\n";
        } else {
            string = String.valueOf(string) + "  [ GOOD ]  SSL v2 Support: " + bl + "\n";
        }
        bl = sSLServerScanResult.isSet(SSLServerScanResult.Flag.SSLV3);
        if (bl) {
            string = String.valueOf(string) + "  [ BAD ]  SSL v3 Support: " + bl + "\n";
            iScanAlert = this.scanInstance.createAlert("ssl-v3-support", String.valueOf(this.host) + "-sslv3");
            iScanAlert.setDiscretionaryHostname(this.hostString);
            iScanAlert.setResource(this.hostString);
            this.scanInstance.addAlert(iScanAlert);
        } else {
            string = String.valueOf(string) + "  [ GOOD ]  SSL v3 Support: " + bl + "\n";
        }
        string = String.valueOf(string) + "  [ INFO ] TLS 1.0 Support: " + sSLServerScanResult.isSet(SSLServerScanResult.Flag.TLS1) + "\n";
        string = String.valueOf(string) + "  [ INFO ] TLS 1.1 Support: " + sSLServerScanResult.isSet(SSLServerScanResult.Flag.TLS11) + "\n";
        string = String.valueOf(string) + "  [ INFO ] TLS 1.2 Support: " + sSLServerScanResult.isSet(SSLServerScanResult.Flag.TLS12) + "\n";
        string = String.valueOf(string) + "\nTLS Configuration Summary\n";
        string = String.valueOf(string) + "--------------------------------------------------------\n";
        if (sSLServerScanResult.isSet(SSLServerScanResult.Flag.TLS_COMPRESSION)) {
            string = String.valueOf(string) + "  [ BAD ]  TLS compression supported (CRIME attack).\n";
            iScanAlert = this.scanInstance.createAlert("ssl-compression", String.valueOf(this.host) + "-compression");
            iScanAlert.setDiscretionaryHostname(this.hostString);
            iScanAlert.setResource(this.hostString);
            this.scanInstance.addAlert(iScanAlert);
        } else {
            string = String.valueOf(string) + "  [ GOOD ] TLS compression not supported.\n";
        }
        if (sSLServerScanResult.isSet(SSLServerScanResult.Flag.ANON_DH)) {
            string = String.valueOf(string) + "  [ INFO ] Supported cipher spec found with Anon-DH key exchange.\n";
            iScanAlert = this.scanInstance.createAlert("ssl-anonymous-dh", String.valueOf(this.host) + "-anonymous-dh");
            iScanAlert.setDiscretionaryHostname(this.hostString);
            iScanAlert.setResource(this.hostString);
            this.scanInstance.addAlert(iScanAlert);
        }
        if (sSLServerScanResult.isSet(SSLServerScanResult.Flag.RC4_SUPPORTED)) {
            string = String.valueOf(string) + "  [ INFO ] Supported ciphers using RC4 found (common).\n";
        }
        if (sSLServerScanResult.isSet(SSLServerScanResult.Flag.SMALL_RSA_KEY)) {
            string = String.valueOf(string) + "  [ BAD ]  Small RSA modulus (<= 1024 bit) found in a server certificate.\n";
            iScanAlert = this.scanInstance.createAlert("ssl-small-key", String.valueOf(this.host) + "-small-key");
            iScanAlert.setDiscretionaryHostname(this.hostString);
            iScanAlert.setResource(this.hostString);
            this.scanInstance.addAlert(iScanAlert);
        }
        if (sSLServerScanResult.isSet(SSLServerScanResult.Flag.SELF_SIGNED_CERTIFICATE)) {
            string = String.valueOf(string) + "  [ INFO ] Self-signed certificate found.\n";
            iScanAlert = this.scanInstance.createAlert("ssl-self-signed", String.valueOf(this.host) + "-self-signed");
            iScanAlert.setDiscretionaryHostname(this.hostString);
            iScanAlert.setResource(this.hostString);
            this.scanInstance.addAlert(iScanAlert);
        }
        if (sSLServerScanResult.isSet(SSLServerScanResult.Flag.MD5_SIGNED_CERTIFICATE)) {
            string = String.valueOf(string) + "  [ BAD ] Certificate signed using MD5. \n";
            iScanAlert = this.scanInstance.createAlert("ssl-md5-cert", String.valueOf(this.host) + "-md5-cert");
            iScanAlert.setDiscretionaryHostname(this.hostString);
            iScanAlert.setResource(this.hostString);
            this.scanInstance.addAlert(iScanAlert);
        }
        if (sSLServerScanResult.isSet(SSLServerScanResult.Flag.SHA1_SIGNED_CERTIFICATE)) {
            string = String.valueOf(string) + "  [ BAD ] Certificate signed using SHA1. \n";
            iScanAlert = this.scanInstance.createAlert("ssl-sha1-cert", String.valueOf(this.host) + "-sha1-cert");
            iScanAlert.setDiscretionaryHostname(this.hostString);
            iScanAlert.setResource(this.hostString);
            this.scanInstance.addAlert(iScanAlert);
        }
        if (sSLServerScanResult.isSet(SSLServerScanResult.Flag.SERVER_PREFERENCE)) {
            string = String.valueOf(string) + "\n\n  [ GOOD ] Server cipher spec preference detected. Server preference order: \n";
            int n = 1;
            for (TLSCipherSpec object2 : sSLServerScanResult.getServerTLSCiphersServerPreferenceOrder()) {
                string = String.valueOf(string) + "    [" + n + "] " + object2.getName() + "\n";
                if (object2.getStrength() == TLSCipherSpec.keyStrength.EXPORT) {
                    string = String.valueOf(string) + "      [ BAD ] Cipher spec is export grade.\n";
                } else if (object2.getStrength() == TLSCipherSpec.keyStrength.LOW) {
                    string = String.valueOf(string) + "      [ BAD ] Cipher spec is low security.\n";
                } else if (object2.getStrength() == TLSCipherSpec.keyStrength.NONE) {
                    string = String.valueOf(string) + "      [ BAD ] Cipher spec does not include encryption.\n";
                }
                if (object2.isAnonDH()) {
                    string = String.valueOf(string) + "      [ BAD ] Cipher spec supports Anonymous DH.\n";
                }
                if (object2.isPFS()) {
                    string = String.valueOf(string) + "      [ GOOD ] Cipher spec offers PFS.\n";
                }
                if (object2.isRC4()) {
                    string = String.valueOf(string) + "      [ BAD ] Cipher spec uses RC4.\n";
                }
                ++n;
            }
            if (!sSLServerScanResult.getServerTLSCiphersServerPreferenceOrder().get(0).isPFS()) {
                string = String.valueOf(string) + "  [ BAD ]  Server most preferred cipher does not offer PFS: " + sSLServerScanResult.getServerTLSCiphersServerPreferenceOrder().get(0).getName() + "\n";
                IScanAlert iScanAlert2 = this.scanInstance.createAlert("ssl-pfs-not-preferred", String.valueOf(this.host) + "-pfs-not-preferred");
                iScanAlert2.setDiscretionaryHostname(this.hostString);
                iScanAlert2.setResource(this.hostString);
                this.scanInstance.addAlert(iScanAlert2);
            } else if (sSLServerScanResult.getServerTLSCiphersServerPreferenceOrder().get(0).isPFS()) {
                string = String.valueOf(string) + "  [ GOOD ] Server most preferred cipher offers PFS: " + sSLServerScanResult.getServerTLSCiphersServerPreferenceOrder().get(0).getName() + "\n";
            }
            if (sSLServerScanResult.getServerTLSCiphersServerPreferenceOrder().get(0).isRC4()) {
                string = String.valueOf(string) + "  [ BAD ]  Server most preferred cipher uses RC4: " + sSLServerScanResult.getServerTLSCiphersServerPreferenceOrder().get(0).getName() + "\n";
                IScanAlert iScanAlert3 = this.scanInstance.createAlert("ssl-rc4-preference", String.valueOf(this.host) + "-rc4-preference");
                iScanAlert3.setResource(this.hostString);
                iScanAlert3.setDiscretionaryHostname(this.hostString);
                this.scanInstance.addAlert(iScanAlert3);
            }
        } else {
            string = String.valueOf(string) + "\n  [ BAD ]  Client cipher spec preference detected. Supported cipher specs:\n";
            if (!sSLServerScanResult.getServerTLSCiphers().isEmpty()) {
                iScanAlert = this.scanInstance.createAlert("ssl-client-preference", String.valueOf(this.host) + "-client-preference");
                iScanAlert.setDiscretionaryHostname(this.hostString);
                iScanAlert.setResource(this.hostString);
                this.scanInstance.addAlert(iScanAlert);
                if (sSLServerScanResult.isSet(SSLServerScanResult.Flag.PFS_SUPPORTED)) {
                    string = String.valueOf(string) + "  [ GOOD ]  Ciphers offering PFS supported.\n";
                } else {
                    string = String.valueOf(string) + "  [ BAD ]  No ciphers offering PFS supported.\n";
                    IScanAlert iScanAlert4 = this.scanInstance.createAlert("ssl-no-pfs", String.valueOf(this.host) + "-no-pfs");
                    iScanAlert4.setDiscretionaryHostname(this.hostString);
                    iScanAlert4.setResource(this.hostString);
                    this.scanInstance.addAlert(iScanAlert4);
                }
                for (TLSCipherSpec tLSCipherSpec : sSLServerScanResult.getServerTLSCiphers()) {
                    string = String.valueOf(string) + "    [*] " + tLSCipherSpec.getName() + "\n";
                    if (tLSCipherSpec.getStrength() == TLSCipherSpec.keyStrength.EXPORT) {
                        string = String.valueOf(string) + "      [ BAD ] Cipher spec is export grade.\n";
                    } else if (tLSCipherSpec.getStrength() == TLSCipherSpec.keyStrength.LOW) {
                        string = String.valueOf(string) + "      [ BAD ] Cipher spec is low security.\n";
                    } else if (tLSCipherSpec.getStrength() == TLSCipherSpec.keyStrength.NONE) {
                        string = String.valueOf(string) + "      [ BAD ] Cipher spec does not include encryption.\n";
                    }
                    if (tLSCipherSpec.isAnonDH()) {
                        string = String.valueOf(string) + "      [ BAD ] Cipher spec supports Anonymous DH.\n";
                    }
                    if (tLSCipherSpec.isPFS()) {
                        string = String.valueOf(string) + "      [ GOOD ] Cipher spec offers PFS.\n";
                    }
                    if (!tLSCipherSpec.isRC4()) continue;
                    string = String.valueOf(string) + "      [ BAD ] Cipher spec uses RC4.\n";
                }
            }
        }
        if (sSLServerScanResult.isSet(SSLServerScanResult.Flag.SSLV2)) {
            string = String.valueOf(string) + "\nSSLv2 Ciphers Supported:\n";
            for (SSLv2CipherSpec sSLv2CipherSpec : sSLServerScanResult.getServerSSLv2Ciphers()) {
                string = String.valueOf(string) + "    [*] " + sSLv2CipherSpec.getName() + "\n";
                if (sSLv2CipherSpec.getStrength() == SSLv2CipherSpec.keyStrength.EXPORT) {
                    string = String.valueOf(string) + "      [ BAD ] Cipher spec is export grade.\n";
                } else if (sSLv2CipherSpec.getStrength() == SSLv2CipherSpec.keyStrength.LOW) {
                    string = String.valueOf(string) + "      [ BAD ] Cipher spec is low security.\n";
                } else if (sSLv2CipherSpec.getStrength() == SSLv2CipherSpec.keyStrength.NONE) {
                    string = String.valueOf(string) + "      [ BAD ] Cipher spec does not include encryption.\n";
                }
                if (!sSLv2CipherSpec.isRC4()) continue;
                string = String.valueOf(string) + "      [ BAD ] Cipher spec uses RC4.\n";
            }
        }
        string = String.valueOf(string) + "\nCertificate Analysis\n";
        string = String.valueOf(string) + "--------------------------------------------------------\n";
        for (CertificateAnalyzer certificateAnalyzer : sSLServerScanResult.getServerCertificates()) {
            string = String.valueOf(string) + "  [*] Certificate: " + certificateAnalyzer.getCertificate().getSerialNumber() + "\n";
            if (certificateAnalyzer.isRSA()) {
                string = certificateAnalyzer.getRSAModulusBitLength() <= 1024 ? String.valueOf(string) + "    [ BAD ]  RSA modulus <= 1024 found.\n" : String.valueOf(string) + "    [ GOOD ] RSA modulus size: " + certificateAnalyzer.getRSAModulusBitLength() + " bits.\n";
            }
            string = certificateAnalyzer.selfSigned() ? String.valueOf(string) + "    [ INFO ] Self-signed certificate found.\n" : String.valueOf(string) + "    [ INFO ] Not self signed.\n";
        }
        string = String.valueOf(string) + "\nSSL Probe completed.\n";
        this.logger.log(Level.INFO, string);
    }
}

