/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.sslprobe;

import com.subgraph.vega.internal.sslprobe.CertificateAnalyzer;
import com.subgraph.vega.internal.sslprobe.CipherSuites;
import com.subgraph.vega.internal.sslprobe.ProbeBase;
import com.subgraph.vega.internal.sslprobe.SSLServerScanResult;
import com.subgraph.vega.internal.sslprobe.TLSAlertException;
import com.subgraph.vega.internal.sslprobe.TLSCipherSpec;
import com.subgraph.vega.internal.sslprobe.TLSProbeResult;
import com.subgraph.vega.internal.sslprobe.TLSProtocol;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

public class TLSCipherProbeTask
extends ProbeBase<TLSProbeResult>
implements Callable<TLSProbeResult> {
    private final Logger logger = Logger.getLogger(TLSCipherProbeTask.class.getName());
    private List<TLSCipherSpec> partition;

    TLSCipherProbeTask(SSLServerScanResult sSLServerScanResult, List<TLSCipherSpec> list) {
        super(sSLServerScanResult);
        this.partition = list;
    }

    @Override
    public TLSProbeResult runProbe() throws Exception {
        try {
            TLSProtocol tLSProtocol = new TLSProtocol(this.getInputStream(), this.getOutputStream());
            tLSProtocol.sendTLSClientHello(this.partition);
            return this.analyzeServerResponses(tLSProtocol);
        }
        catch (TLSAlertException tLSAlertException) {
            TLSProbeResult tLSProbeResult = new TLSProbeResult();
            tLSProbeResult.addCiphers(this.partition, null);
            return tLSProbeResult;
        }
        catch (UnknownHostException unknownHostException) {
            return this.createErrorResult("Unknown host");
        }
        catch (IOException iOException) {
            return this.createErrorResult("I/O error: " + iOException);
        }
    }

    private TLSProbeResult createErrorResult(String string) {
        TLSProbeResult tLSProbeResult = new TLSProbeResult();
        tLSProbeResult.setError(true, string);
        return tLSProbeResult;
    }

    private TLSProbeResult analyzeServerResponses(TLSProtocol tLSProtocol) throws IOException, TLSAlertException {
        TLSProbeResult tLSProbeResult = new TLSProbeResult();
        while (true) {
            ByteBuffer byteBuffer;
            if ((byteBuffer = tLSProtocol.getNextHandshakeMessage()) == null) {
                this.addDroppedRejected(tLSProbeResult);
                return tLSProbeResult;
            }
            int n = byteBuffer.get() & 0xFF;
            int n2 = tLSProtocol.getInt24(byteBuffer);
            if (byteBuffer.remaining() < n2) {
                this.logger.info("Ignoring short handshake message");
                continue;
            }
            if (this.analyzeHandshakeResponse(tLSProtocol, n, byteBuffer, tLSProbeResult)) break;
        }
        return tLSProbeResult;
    }

    private boolean analyzeHandshakeResponse(TLSProtocol tLSProtocol, int n, ByteBuffer byteBuffer, TLSProbeResult tLSProbeResult) {
        switch (n) {
            case 2: {
                this.analyzeServerHello(tLSProtocol, byteBuffer, tLSProbeResult);
                break;
            }
            case 11: {
                this.analyzeCertificateMessage(tLSProtocol, byteBuffer, tLSProbeResult);
                break;
            }
            case 14: {
                return true;
            }
            case 12: {
                break;
            }
            default: {
                this.logger.info("Unexpected handshake message received with type = " + n);
            }
        }
        return false;
    }

    private void addDroppedRejected(TLSProbeResult tLSProbeResult) {
        ArrayList<TLSCipherSpec> arrayList = new ArrayList<TLSCipherSpec>();
        for (TLSCipherSpec tLSCipherSpec : this.partition) {
            arrayList.add(tLSCipherSpec);
        }
        tLSProbeResult.addRejectedCiphersOnly(arrayList);
    }

    private void analyzeServerHello(TLSProtocol tLSProtocol, ByteBuffer byteBuffer, TLSProbeResult tLSProbeResult) {
        int n;
        TLSCipherSpec tLSCipherSpec;
        if (tLSProtocol.extractCompressionFromServerHello(byteBuffer) != 0) {
            tLSProbeResult.setTLSCompressionSupport(true);
        }
        if ((tLSCipherSpec = CipherSuites.lookupTLSCipher(n = tLSProtocol.extractCipherFromServerHello(byteBuffer))) == null) {
            this.logger.warning("Could not find cipher constant " + n);
            return;
        }
        ArrayList<TLSCipherSpec> arrayList = new ArrayList<TLSCipherSpec>();
        for (TLSCipherSpec tLSCipherSpec2 : this.partition) {
            if (tLSCipherSpec == tLSCipherSpec2) continue;
            arrayList.add(tLSCipherSpec2);
        }
        tLSProbeResult.addCiphers(arrayList, tLSCipherSpec);
    }

    private void analyzeCertificateMessage(TLSProtocol tLSProtocol, ByteBuffer byteBuffer, TLSProbeResult tLSProbeResult) {
        int n = tLSProtocol.getInt24(byteBuffer);
        if (byteBuffer.remaining() < n) {
            this.logger.warning("Message length is less than expected length of certificate chain");
            return;
        }
        CertificateAnalyzer certificateAnalyzer = new CertificateAnalyzer();
        while (byteBuffer.hasRemaining()) {
            X509Certificate x509Certificate = this.readCertificate(tLSProtocol, byteBuffer);
            certificateAnalyzer.addCert(x509Certificate);
        }
        tLSProbeResult.addCertificate(certificateAnalyzer);
    }

    private X509Certificate readCertificate(TLSProtocol tLSProtocol, ByteBuffer byteBuffer) {
        int n = tLSProtocol.getInt24(byteBuffer);
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        try {
            return X509Certificate.getInstance(byArray);
        }
        catch (CertificateException certificateException) {
            this.logger.log(Level.WARNING, "Error creating certificate from message bytes", certificateException);
            return null;
        }
    }
}

