/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.sslprobe;

import com.subgraph.vega.internal.sslprobe.CertificateAnalyzer;
import com.subgraph.vega.internal.sslprobe.SSLv2CipherSpec;
import com.subgraph.vega.internal.sslprobe.TLSCipherSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SSLServerScanResult {
    private final String targetHost;
    private final int targetPort;
    private Set<Flag> flags = Collections.synchronizedSet(EnumSet.noneOf(Flag.class));
    private boolean TLSProbeFailure;
    private String errorMessage;
    private Set<CertificateAnalyzer> certs;
    private List<TLSCipherSpec> serverTLSCiphers;
    private List<SSLv2CipherSpec> serverSSLv2Ciphers;
    private List<TLSCipherSpec> serverPreferenceOrder;
    private int outstandingProbeCount;

    SSLServerScanResult(String string, int n) {
        this.targetHost = string;
        this.targetPort = n;
        this.certs = new HashSet<CertificateAnalyzer>();
        this.serverTLSCiphers = new ArrayList<TLSCipherSpec>();
    }

    public String getTargetHost() {
        return this.targetHost;
    }

    public int getTargetPort() {
        return this.targetPort;
    }

    public synchronized void setTLSProbeFailure(String string) {
        this.errorMessage = string;
        this.TLSProbeFailure = true;
    }

    public synchronized void setServerTLSCiphersServerPreferenceOrder(List<TLSCipherSpec> list) {
        this.serverPreferenceOrder = list;
    }

    public synchronized void setServerSSLv2Ciphers(List<SSLv2CipherSpec> list) {
        this.serverSSLv2Ciphers = list;
    }

    public void addServerTLSCipher(TLSCipherSpec tLSCipherSpec) {
        this.analyzeCipher(tLSCipherSpec);
        this.serverTLSCiphers.add(tLSCipherSpec);
    }

    public List<TLSCipherSpec> getServerTLSCiphers() {
        return Collections.unmodifiableList(new ArrayList<TLSCipherSpec>(this.serverTLSCiphers));
    }

    public void addServerCertificate(CertificateAnalyzer certificateAnalyzer) {
        if (this.certs.add(certificateAnalyzer)) {
            this.analyzeCertificate(certificateAnalyzer);
        }
    }

    private void analyzeCipher(TLSCipherSpec tLSCipherSpec) {
        if (tLSCipherSpec.getStrength() == TLSCipherSpec.keyStrength.EXPORT) {
            this.flags.add(Flag.EXPORT_CIPHERS_SUPPORTED);
        } else if (tLSCipherSpec.getStrength() == TLSCipherSpec.keyStrength.LOW) {
            this.flags.add(Flag.WEAK_CIPHERS_SUPPORTED);
        }
        if (tLSCipherSpec.isAnonDH()) {
            this.flags.add(Flag.ANON_DH);
        }
        if (tLSCipherSpec.isRC4()) {
            this.flags.add(Flag.RC4_SUPPORTED);
        }
        if (tLSCipherSpec.isPFS()) {
            this.flags.add(Flag.PFS_SUPPORTED);
        }
    }

    private void analyzeCertificate(CertificateAnalyzer certificateAnalyzer) {
        if (certificateAnalyzer.selfSigned()) {
            this.flags.add(Flag.SELF_SIGNED_CERTIFICATE);
        }
        if (certificateAnalyzer.isRSA() && certificateAnalyzer.getRSAModulusBitLength() <= 1024) {
            this.flags.add(Flag.SMALL_RSA_KEY);
        }
        if (certificateAnalyzer.isSignedMD5()) {
            this.flags.add(Flag.MD5_SIGNED_CERTIFICATE);
        }
        if (certificateAnalyzer.isSignedSHA1()) {
            this.flags.add(Flag.SHA1_SIGNED_CERTIFICATE);
        }
    }

    public synchronized void setServerTLSCiphers(ArrayList<TLSCipherSpec> arrayList) {
        this.serverTLSCiphers = arrayList;
    }

    public void setFlag(Flag flag) {
        this.flags.add(flag);
    }

    public boolean isSet(Flag flag) {
        return this.flags.contains((Object)flag);
    }

    public boolean getTLSProbeFailure() {
        return this.TLSProbeFailure;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<TLSCipherSpec> getServerTLSCiphersServerPreferenceOrder() {
        return this.serverPreferenceOrder;
    }

    public Collection<CertificateAnalyzer> getServerCertificates() {
        return this.certs;
    }

    public List<SSLv2CipherSpec> getServerSSLv2Ciphers() {
        return this.serverSSLv2Ciphers;
    }

    public synchronized void incrementOutstandingProbeCount() {
        ++this.outstandingProbeCount;
    }

    public synchronized void decrementOutstandingProbeCount() {
        --this.outstandingProbeCount;
        if (this.outstandingProbeCount == 0) {
            this.notifyAll();
        }
    }

    public synchronized void waitForOutstandingProbes() throws InterruptedException {
        while (this.outstandingProbeCount > 0) {
            this.wait();
        }
    }

    public static enum Flag {
        PFS_SUPPORTED,
        PFS_SERVER_PREFERENCE,
        RC4_SERVER_PREFERENCE,
        RC4_SUPPORTED,
        WEAK_CIPHERS_SUPPORTED,
        EXPORT_CIPHERS_SUPPORTED,
        TLS_COMPRESSION,
        ANON_DH,
        SMALL_RSA_KEY,
        SELF_SIGNED_CERTIFICATE,
        SERVER_PREFERENCE,
        SSLV2,
        SSLV3,
        TLS1,
        TLS11,
        TLS12,
        MD5_SIGNED_CERTIFICATE,
        SHA1_SIGNED_CERTIFICATE;

    }
}

