/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.sslprobe;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

public class CertificateAnalyzer {
    private X509Certificate certificate;
    private boolean error = false;

    CertificateAnalyzer() {
    }

    public void addCert(X509Certificate x509Certificate) {
        this.certificate = x509Certificate;
    }

    public boolean selfSigned() {
        PublicKey publicKey = this.certificate.getPublicKey();
        try {
            this.certificate.verify(publicKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            System.out.println("Invalid key, not self signed");
            return false;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return false;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            return false;
        }
        catch (SignatureException signatureException) {
            return false;
        }
        catch (CertificateException certificateException) {
            return false;
        }
        return true;
    }

    public boolean isSignedSHA1() {
        return this.certificate.getSigAlgName().startsWith("SHA1");
    }

    public boolean isSignedMD5() {
        return this.certificate.getSigAlgName().startsWith("MD5");
    }

    public boolean isRSA() {
        return "RSA".equals(this.certificate.getPublicKey().getAlgorithm());
    }

    public int getRSAModulusBitLength() {
        if (this.isRSA()) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)this.certificate.getPublicKey();
            return rSAPublicKey.getModulus().bitLength();
        }
        return -1;
    }

    public void setError(boolean bl) {
        this.error = bl;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public boolean isError() {
        return this.error;
    }

    public int hashCode() {
        return this.certificate == null ? 0 : this.certificate.getSerialNumber().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CertificateAnalyzer certificateAnalyzer = (CertificateAnalyzer)object;
        if (this.certificate == null) {
            return certificateAnalyzer.certificate == null;
        }
        if (this.certificate.getSerialNumber() == null) {
            return certificateAnalyzer.certificate.getSerialNumber() == null;
        }
        return this.certificate.getSerialNumber().equals(certificateAnalyzer.certificate.getSerialNumber());
    }
}

