/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.modules.scripting;

import com.subgraph.vega.api.scanner.modules.IScannerModuleRunningTime;

public class ScriptedModuleRunningTime
implements IScannerModuleRunningTime {
    private final String name;
    private int invocationCount = 0;
    private int totalMilliseconds = 0;
    private int worstTime = -1;
    private String worstTimeTarget;

    public ScriptedModuleRunningTime(String string) {
        this.name = string;
    }

    public synchronized void reset() {
        this.invocationCount = 0;
        this.totalMilliseconds = 0;
        this.worstTime = -1;
    }

    public int getInvocationCount() {
        return this.invocationCount;
    }

    public double getAverageTime() {
        if (this.invocationCount == 0) {
            return 0.0;
        }
        return (double)this.totalMilliseconds / (double)this.invocationCount;
    }

    public int getTotalTime() {
        return this.totalMilliseconds;
    }

    public int getWorstTime() {
        return this.worstTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTimestamp(int n, String string) {
        ScriptedModuleRunningTime scriptedModuleRunningTime = this;
        synchronized (scriptedModuleRunningTime) {
            ++this.invocationCount;
            this.totalMilliseconds += n;
            if (this.worstTime < 0 || n > this.worstTime) {
                this.worstTime = n;
                this.worstTimeTarget = string;
            }
        }
    }

    public String toString() {
        return String.format("Invocations: %3d Average: %8.3f ms [worst: %4d ms @(%s) ] for %s", this.invocationCount, this.getAverageTime(), this.worstTime, this.worstTimeTarget, this.name);
    }
}

