/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.modules.scripting;

import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.WrappedException;

public class RhinoExceptionFormatter {
    private final String message;
    private final RhinoException e;

    public RhinoExceptionFormatter(String string, RhinoException rhinoException) {
        this.message = string;
        this.e = rhinoException;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.valueOf(this.message) + "\nSource file: " + this.e.sourceName() + " at line " + this.e.lineNumber() + " and column " + this.e.columnNumber() + "\n");
        if (this.e.details() != null) {
            stringBuilder.append(String.valueOf(this.e.details()) + "\n");
        }
        if (this.e.lineSource() != null) {
            stringBuilder.append(String.valueOf(this.e.lineSource()) + "\n");
            if (this.e.columnNumber() != 0) {
                int n = 1;
                while (n < this.e.columnNumber()) {
                    stringBuilder.append(" ");
                    ++n;
                }
                stringBuilder.append("^\n");
            }
        }
        if (this.e instanceof WrappedException) {
            WrappedException wrappedException = (WrappedException)((Object)this.e);
            Throwable throwable = wrappedException.getWrappedException();
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                stringBuilder.append("\tat ");
                stringBuilder.append(stackTraceElement);
                stringBuilder.append("\n");
                ++n2;
            }
        }
        return stringBuilder.toString();
    }
}

