/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.modules.scripting;

import com.google.common.io.BaseEncoding;
import com.google.common.net.InternetDomainName;
import com.subgraph.vega.api.crawler.ICrawlerResponseProcessor;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.http.requests.IPageFingerprint;
import com.subgraph.vega.api.scanner.IInjectionModuleContext;
import com.subgraph.vega.api.scanner.IPathState;
import com.subgraph.vega.impl.scanner.modules.scripting.CrawlerCallbackWrapper;
import com.subgraph.vega.impl.scanner.modules.scripting.ResponseJS;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

public class ModuleContextJS {
    private final Scriptable scope;
    private final IInjectionModuleContext context;

    ModuleContextJS(Scriptable scriptable, IInjectionModuleContext iInjectionModuleContext) {
        this.scope = scriptable;
        this.context = iInjectionModuleContext;
    }

    public int getCurrentIndex() {
        return this.context.getCurrentIndex();
    }

    public IPathState getPathState() {
        return this.context.getPathState();
    }

    public int incrementResponseCount() {
        return this.context.incrementResponseCount();
    }

    public boolean allResponsesReceived() {
        return this.context.allResponsesReceived();
    }

    public void setModuleFailed() {
        this.context.setModuleFailed();
    }

    public boolean hasModuleFailed() {
        return this.context.hasModuleFailed();
    }

    public void addRequestResponse(HttpUriRequest httpUriRequest, ResponseJS responseJS) {
        this.context.addRequestResponse(httpUriRequest, responseJS.getResponse());
    }

    public void addRequestResponse(int n, HttpUriRequest httpUriRequest, ResponseJS responseJS) {
        this.context.addRequestResponse(n, httpUriRequest, responseJS.getResponse());
    }

    public HttpUriRequest getSavedRequest(int n) {
        return this.context.getSavedRequest(n);
    }

    public Scriptable getSavedResponse(int n) {
        IHttpResponse iHttpResponse = this.context.getSavedResponse(n);
        Object object = Context.javaToJS((Object)iHttpResponse, (Scriptable)this.scope);
        Object[] objectArray = new Object[]{object};
        return Context.getCurrentContext().newObject(this.scope, "Response", objectArray);
    }

    public Scriptable getOrigResponse() {
        IHttpResponse iHttpResponse = this.context.getPathState().getResponse();
        Object object = Context.javaToJS((Object)iHttpResponse, (Scriptable)this.scope);
        Object[] objectArray = new Object[]{object};
        return Context.getCurrentContext().newObject(this.scope, "Response", objectArray);
    }

    public String getSavedResponseBody(int n) {
        return this.context.getSavedResponseBody(n);
    }

    public IPageFingerprint getSavedFingerprint(int n) {
        return this.context.getSavedFingerprint(n);
    }

    public void error(HttpUriRequest httpUriRequest, ResponseJS responseJS, String string) {
        this.context.error(httpUriRequest, responseJS.getResponse(), string);
    }

    public void debug(String string) {
        this.context.debug(string);
    }

    public void debug(String string, Boolean bl) {
        this.context.debug(string, bl);
    }

    public void analyzePage(HttpUriRequest httpUriRequest, ResponseJS responseJS) {
        this.context.analyzePage(httpUriRequest, responseJS.getResponse());
    }

    public boolean isFingerprintMatch(int n, int n2) {
        return this.context.isFingerprintMatch(n, n2);
    }

    public boolean isFingerprintMatch(int n, IPageFingerprint iPageFingerprint) {
        return this.context.isFingerprintMatch(n, iPageFingerprint);
    }

    public void submitRequest(HttpUriRequest httpUriRequest, Function function, int n) {
        this.context.submitRequest(httpUriRequest, (ICrawlerResponseProcessor)this.wrap(function), n);
    }

    public void submitRequest(HttpUriRequest httpUriRequest, Function function) {
        this.context.submitRequest(httpUriRequest, (ICrawlerResponseProcessor)this.wrap(function));
    }

    public void submitRequest(Function function, int n) {
        this.context.submitRequest((ICrawlerResponseProcessor)this.wrap(function), n);
    }

    public void submitAlteredRequest(Function function, String string) {
        this.context.submitAlteredRequest((ICrawlerResponseProcessor)this.wrap(function), string);
    }

    public void submitAlteredRequest(Function function, String string, int n) {
        this.context.submitAlteredRequest((ICrawlerResponseProcessor)this.wrap(function), string, n);
    }

    public void submitAlteredRequest(Function function, String string, boolean bl, int n) {
        this.context.submitAlteredRequest((ICrawlerResponseProcessor)this.wrap(function), string, bl, n);
    }

    public void submitAlteredParameterNameRequest(Function function, String string, int n) {
        this.context.submitAlteredParameterNameRequest((ICrawlerResponseProcessor)this.wrap(function), string, n);
    }

    public void submitMultipleAlteredRequests(Function function, String[] stringArray) {
        this.context.submitMultipleAlteredRequests((ICrawlerResponseProcessor)this.wrap(function), stringArray);
    }

    public void submitMultipleAlteredRequests(Function function, String[] stringArray, boolean bl) {
        this.context.submitMultipleAlteredRequests((ICrawlerResponseProcessor)this.wrap(function), stringArray, bl);
    }

    public void responseChecks(HttpUriRequest httpUriRequest, ResponseJS responseJS) {
        this.context.responseChecks(httpUriRequest, responseJS.getResponse());
    }

    public void contentChecks(HttpUriRequest httpUriRequest, ResponseJS responseJS) {
        this.context.contentChecks(httpUriRequest, responseJS.getResponse());
    }

    public void responseChecks(int n) {
        this.context.responseChecks(n);
    }

    public void pivotChecks(HttpUriRequest httpUriRequest, ResponseJS responseJS) {
        this.context.pivotChecks(httpUriRequest, responseJS.getResponse());
    }

    private CrawlerCallbackWrapper wrap(Function function) {
        return new CrawlerCallbackWrapper(function);
    }

    public void addStringHighlight(String string) {
        this.context.addStringHighlight(string);
    }

    public void addRegexHighlight(String string) {
        this.context.addRegexHighlight(string);
    }

    public void addRegexCaseInsensitiveHighlight(String string) {
        this.context.addRegexCaseInsensitiveHighlight(string);
    }

    public void reset() {
        this.context.reset();
    }

    public void alert(String string, HttpUriRequest httpUriRequest, ResponseJS responseJS) {
        this.alert(string, (HttpRequest)httpUriRequest, responseJS, null);
    }

    public void alert(String string, HttpRequest httpRequest, ResponseJS responseJS, Scriptable scriptable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        String string3 = null;
        if (scriptable == null) {
            this.publishAlert(string, null, httpRequest, responseJS.getResponse());
            return;
        }
        Object[] objectArray = scriptable.getIds();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string4;
            String string5;
            Object object = objectArray[n2];
            if (object instanceof String && (string5 = this.lookup(string4 = (String)object, scriptable)) != null) {
                if ("key".equals(string4)) {
                    string2 = string5;
                } else if ("message".equals(string4)) {
                    string3 = string5;
                } else {
                    arrayList.add(string4);
                    arrayList.add(string5);
                }
            }
            ++n2;
        }
        this.context.publishAlert(string, string2, string3, httpRequest, responseJS.getResponse(), arrayList.toArray());
    }

    private String lookup(String string, Scriptable scriptable) {
        Object object = scriptable.get(string, scriptable);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Wrapper) {
            Wrapper wrapper = (Wrapper)object;
            if (wrapper.unwrap() instanceof String) {
                return (String)wrapper.unwrap();
            }
            return null;
        }
        return null;
    }

    public void publishAlert(String string, String string2, HttpRequest httpRequest, IHttpResponse iHttpResponse) {
        this.context.publishAlert(string, string2, httpRequest, iHttpResponse, new Object[0]);
    }

    public void publishAlert(String string, String string2, String string3, HttpRequest httpRequest, IHttpResponse iHttpResponse) {
        this.context.publishAlert(string, string2, string3, httpRequest, iHttpResponse, new Object[0]);
    }

    public void setProperty(String string, Object object) {
        this.context.setProperty(string, object);
    }

    public void setStringProperty(String string, String string2) {
        this.context.setStringProperty(string, string2);
    }

    public void setIntegerProperty(String string, int n) {
        this.context.setIntegerProperty(string, n);
    }

    public Object getProperty(String string) {
        return this.context.getProperty(string);
    }

    public String getStringProperty(String string) {
        return this.context.getStringProperty(string);
    }

    public Integer getIntegerProperty(String string) {
        return this.context.getIntegerProperty(string);
    }

    public Object propertyKeys() {
        List list = this.context.propertyKeys();
        Context context = Context.getCurrentContext();
        Scriptable scriptable = context.newArray(this.scope, list.size());
        int n = 0;
        while (n < list.size()) {
            scriptable.put(n, scriptable, Context.javaToJS(list.get(n), (Scriptable)this.scope));
            ++n;
        }
        return scriptable;
    }

    public boolean alertExists(String string) {
        return this.context.alertExists(string);
    }

    public InternetDomainName internetDomainName(String string) {
        return this.context.internetDomainName(string);
    }

    public boolean isValidInternetDomainName(String string) {
        return this.context.isValidInternetDomainName(string);
    }

    public String base64decode(String string) {
        byte[] byArray = BaseEncoding.base64().decode((CharSequence)string);
        return new String(byArray);
    }

    public String base64encode(String string) {
        String string2 = BaseEncoding.base64().encode(string.getBytes());
        return string2;
    }
}

