/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.modules.scripting;

import com.subgraph.vega.api.scanner.IInjectionModuleContext;
import com.subgraph.vega.api.scanner.IPathState;
import com.subgraph.vega.api.scanner.modules.IBasicModuleScript;
import com.subgraph.vega.api.scanner.modules.IEnableableModule;
import com.subgraph.vega.impl.scanner.modules.scripting.ModuleContextJS;
import com.subgraph.vega.impl.scanner.modules.scripting.RhinoExceptionFormatter;
import com.subgraph.vega.impl.scanner.modules.scripting.ScriptedModule;
import com.subgraph.vega.impl.scanner.modules.scripting.ScriptedModuleRunningTime;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrappedException;

public class BasicModuleScript
implements IBasicModuleScript,
IEnableableModule {
    private static final Logger logger = Logger.getLogger("script-module");
    private final ScriptedModule module;
    private final ScriptedModuleRunningTime runningTime;
    private boolean isEnabled;

    public BasicModuleScript(ScriptedModule scriptedModule, boolean bl, ScriptedModuleRunningTime scriptedModuleRunningTime) {
        this.module = scriptedModule;
        this.isEnabled = bl;
        this.runningTime = scriptedModuleRunningTime;
    }

    public BasicModuleScript(ScriptedModule scriptedModule) {
        this.module = scriptedModule;
        this.isEnabled = scriptedModule.isDefaultEnabled();
        this.runningTime = new ScriptedModuleRunningTime(scriptedModule.getModuleName());
    }

    public ScriptedModule getModule() {
        return this.module;
    }

    public void runScript(IPathState iPathState) {
        IInjectionModuleContext iInjectionModuleContext = iPathState.createModuleContext();
        try {
            try {
                Context context = Context.enter();
                Scriptable scriptable = this.module.createInstanceScope(context);
                Object[] objectArray = new Object[]{new ModuleContextJS(scriptable, iInjectionModuleContext)};
                long l = System.currentTimeMillis();
                this.module.runModule(context, scriptable, objectArray);
                long l2 = System.currentTimeMillis();
                this.runningTime.addTimestamp((int)(l2 - l), iPathState.toString());
            }
            catch (WrappedException wrappedException) {
                logger.log(Level.WARNING, new RhinoExceptionFormatter("Wrapped exception running module script: " + this.module.getModuleName(), (RhinoException)((Object)wrappedException)).toString());
                Context.exit();
            }
            catch (RhinoException rhinoException) {
                logger.warning(new RhinoExceptionFormatter("Exception running module script: " + this.module.getModuleName(), rhinoException).toString());
                Context.exit();
            }
        }
        finally {
            Context.exit();
        }
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String getModuleName() {
        return this.module.getModuleName();
    }

    public String getModuleCategoryName() {
        return this.module.getCategoryName();
    }

    public ScriptedModuleRunningTime getRunningTimeProfile() {
        return this.runningTime;
    }

    public boolean isDifferential() {
        return this.module.isDifferential();
    }

    public boolean isTimeSensitive() {
        return this.module.isTimeSensitive();
    }
}

