/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.modules.scripting;

import com.subgraph.vega.api.scanner.modules.IEnableableModule;
import com.subgraph.vega.api.scanner.modules.IScannerModule;
import com.subgraph.vega.api.scanner.modules.IScannerModuleRunningTime;
import com.subgraph.vega.api.scanner.modules.ModuleScriptType;
import com.subgraph.vega.impl.scanner.modules.scripting.RhinoExceptionFormatter;
import com.subgraph.vega.impl.scanner.modules.scripting.ScriptedModule;
import com.subgraph.vega.impl.scanner.modules.scripting.ScriptedModuleRunningTime;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;

public abstract class AbstractScriptModule
implements IScannerModule,
IEnableableModule {
    private static final Logger logger = Logger.getLogger("script-module");
    private final ScriptedModule module;
    private final ScriptedModuleRunningTime runningTime;
    private boolean isEnabled;

    protected AbstractScriptModule(ScriptedModule scriptedModule) {
        this.module = scriptedModule;
        this.isEnabled = scriptedModule.isDefaultEnabled();
        this.runningTime = new ScriptedModuleRunningTime(scriptedModule.getModuleName());
    }

    public String getModuleName() {
        return this.module.getModuleName();
    }

    public String getModuleCategoryName() {
        return this.module.getCategoryName();
    }

    public ModuleScriptType getModuleType() {
        return this.module.getModuleType();
    }

    protected void runScript(List<ExportedObject> list, String string) {
        try {
            try {
                Context context = Context.enter();
                Scriptable scriptable = this.module.createInstanceScope(context);
                this.processExports(list, scriptable);
                long l = System.currentTimeMillis();
                this.module.runModule(context, scriptable);
                long l2 = System.currentTimeMillis();
                this.runningTime.addTimestamp((int)(l2 - l), string);
            }
            catch (WrappedException wrappedException) {
                logger.log(Level.WARNING, new RhinoExceptionFormatter("Wrapped exception running module script", (RhinoException)((Object)wrappedException)).toString());
                wrappedException.printStackTrace();
                Context.exit();
            }
            catch (RhinoException rhinoException) {
                logger.warning(new RhinoExceptionFormatter("Exception running module script.", rhinoException).toString());
                Context.exit();
            }
        }
        finally {
            Context.exit();
        }
    }

    public IScannerModuleRunningTime getRunningTimeProfile() {
        return this.runningTime;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    protected void export(List<ExportedObject> list, String string, Object object) {
        list.add(new ExportedObject(string, object));
    }

    private void processExports(List<ExportedObject> list, Scriptable scriptable) {
        for (ExportedObject exportedObject : list) {
            Object object = Context.javaToJS((Object)exportedObject.object, (Scriptable)scriptable);
            ScriptableObject.putProperty((Scriptable)scriptable, (String)exportedObject.identifier, (Object)object);
        }
    }

    protected static class ExportedObject {
        private final String identifier;
        private final Object object;

        ExportedObject(String string, Object object) {
            this.identifier = string;
            this.object = object;
        }
    }
}

