/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.modules;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.html.IHTMLParser;
import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.WorkspaceCloseEvent;
import com.subgraph.vega.api.model.WorkspaceOpenEvent;
import com.subgraph.vega.api.paths.IPathFinder;
import com.subgraph.vega.api.scanner.modules.IBasicModuleScript;
import com.subgraph.vega.api.scanner.modules.IResponseProcessingModule;
import com.subgraph.vega.api.scanner.modules.IScannerModuleRegistry;
import com.subgraph.vega.api.scanner.modules.ModuleScriptType;
import com.subgraph.vega.impl.scanner.modules.scripting.BasicModuleScript;
import com.subgraph.vega.impl.scanner.modules.scripting.ResponseProcessorScript;
import com.subgraph.vega.impl.scanner.modules.scripting.ScriptLoader;
import com.subgraph.vega.impl.scanner.modules.scripting.ScriptedModule;
import com.subgraph.vega.impl.scanner.modules.scripting.tests.DomTestModule;
import com.subgraph.vega.impl.scanner.modules.scripting.tests.TestScriptLoader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ScannerModuleRepository
implements IScannerModuleRegistry {
    private final Logger logger = Logger.getLogger("modules");
    private IPathFinder pathFinder;
    private IHTMLParser htmlParser;
    private IModel model;
    private ScriptLoader scriptLoader;
    private TestScriptLoader testScriptLoader;
    private Bundle bundle;
    private IWorkspace currentWorkspace;

    void activate(BundleContext bundleContext) {
        this.bundle = bundleContext.getBundle();
        this.scriptLoader = new ScriptLoader(this.getScriptDirectory());
        this.scriptLoader.reloadModules();
        this.currentWorkspace = this.model.addWorkspaceListener(new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof WorkspaceOpenEvent) {
                    ScannerModuleRepository.this.handleWorkspaceOpen((WorkspaceOpenEvent)iEvent);
                } else if (iEvent instanceof WorkspaceCloseEvent) {
                    ScannerModuleRepository.this.handleWorkspaceClose((WorkspaceCloseEvent)iEvent);
                }
            }
        });
    }

    private void handleWorkspaceOpen(WorkspaceOpenEvent workspaceOpenEvent) {
        this.currentWorkspace = workspaceOpenEvent.getWorkspace();
    }

    private void handleWorkspaceClose(WorkspaceCloseEvent workspaceCloseEvent) {
        this.currentWorkspace = null;
    }

    private File getScriptDirectory() {
        File file = this.getScriptDirectoryFromConfig(this.pathFinder.getConfigFilePath());
        if (file != null && file.exists() && file.isDirectory()) {
            return file;
        }
        return new File(this.pathFinder.getDataDirectory(), "scripts" + File.separator + "scanner");
    }

    private File getScriptDirectoryFromConfig(File file) {
        Reader reader = null;
        try {
            if (!file.exists() || !file.canRead()) {
                return null;
            }
            reader = new FileReader(file);
            Properties properties = new Properties();
            properties.load(reader);
            String string = properties.getProperty("vega.scanner.datapath");
            if (string != null) {
                File file2 = new File(string, "scripts" + File.separator + "scanner");
                return file2;
            }
        }
        catch (IOException iOException) {
            this.logger.log(Level.WARNING, "I/O error opening config file " + file.getAbsolutePath(), iOException);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                this.logger.log(Level.WARNING, "I/O error closing config file " + file.getAbsolutePath(), iOException);
            }
        }
        return null;
    }

    public List<IResponseProcessingModule> getResponseProcessingModules() {
        ArrayList<IResponseProcessingModule> arrayList = new ArrayList<IResponseProcessingModule>();
        for (ScriptedModule scriptedModule : this.scriptLoader.getAllModules()) {
            if (scriptedModule.getModuleType() != ModuleScriptType.RESPONSE_PROCESSOR) continue;
            arrayList.add(new ResponseProcessorScript(scriptedModule));
        }
        return arrayList;
    }

    public List<IBasicModuleScript> getBasicModules() {
        ArrayList<IBasicModuleScript> arrayList = new ArrayList<IBasicModuleScript>();
        for (ScriptedModule scriptedModule : this.scriptLoader.getAllModules()) {
            if (scriptedModule.getModuleType() != ModuleScriptType.BASIC_MODULE) continue;
            arrayList.add(new BasicModuleScript(scriptedModule));
        }
        return arrayList;
    }

    protected void setPathFinder(IPathFinder iPathFinder) {
        this.pathFinder = iPathFinder;
    }

    protected void unsetPathFinder(IPathFinder iPathFinder) {
        this.pathFinder = null;
    }

    protected void setHTMLParser(IHTMLParser iHTMLParser) {
        this.htmlParser = iHTMLParser;
    }

    protected void unsetHTMLParser(IHTMLParser iHTMLParser) {
        this.htmlParser = null;
    }

    protected void setModel(IModel iModel) {
        this.model = iModel;
    }

    protected void unsetModel(IModel iModel) {
        this.model = null;
    }

    public void runDomTests() {
        if (this.testScriptLoader == null) {
            this.testScriptLoader = new TestScriptLoader(this.scriptLoader.getPreludeScope(), this.bundle);
            this.testScriptLoader.load();
        }
        Thread thread = new Thread(this.createDomTestRunnable());
        thread.start();
    }

    private Runnable createDomTestRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                for (ScriptedModule scriptedModule : ScannerModuleRepository.this.testScriptLoader.getAllModules()) {
                    ScannerModuleRepository.this.runDomTestModule(scriptedModule);
                }
            }
        };
    }

    private void runDomTestModule(ScriptedModule scriptedModule) {
        if (scriptedModule.getModuleType() != ModuleScriptType.DOM_TEST) {
            return;
        }
        DomTestModule domTestModule = new DomTestModule(scriptedModule, this.bundle, this.htmlParser);
        try {
            domTestModule.run(this.currentWorkspace);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public List<IResponseProcessingModule> updateResponseProcessingModules(List<IResponseProcessingModule> list) {
        Object object;
        if (!this.scriptLoader.reloadModules()) {
            return list;
        }
        LinkedHashMap<String, ResponseProcessorScript> linkedHashMap = new LinkedHashMap<String, ResponseProcessorScript>();
        ArrayList<IResponseProcessingModule> arrayList = new ArrayList<IResponseProcessingModule>();
        for (IResponseProcessingModule object2 : list) {
            if (!(object2 instanceof ResponseProcessorScript)) continue;
            object = (ResponseProcessorScript)object2;
            linkedHashMap.put(((ResponseProcessorScript)object).getModule().getScriptFile().getPath(), (ResponseProcessorScript)object);
        }
        for (ScriptedModule scriptedModule : this.scriptLoader.getAllModulesByType(ModuleScriptType.RESPONSE_PROCESSOR)) {
            object = scriptedModule.getScriptFile().getPath();
            if (linkedHashMap.containsKey(object)) {
                ResponseProcessorScript responseProcessorScript = (ResponseProcessorScript)linkedHashMap.get(object);
                arrayList.add(new ResponseProcessorScript(scriptedModule, responseProcessorScript.isEnabled(), responseProcessorScript.getRunningTimeProfile()));
                continue;
            }
            arrayList.add(new ResponseProcessorScript(scriptedModule));
        }
        return arrayList;
    }

    public List<IBasicModuleScript> updateBasicModules(List<IBasicModuleScript> list) {
        Object object;
        if (!this.scriptLoader.reloadModules()) {
            return list;
        }
        LinkedHashMap<String, BasicModuleScript> linkedHashMap = new LinkedHashMap<String, BasicModuleScript>();
        ArrayList<IBasicModuleScript> arrayList = new ArrayList<IBasicModuleScript>();
        for (IBasicModuleScript object2 : list) {
            if (!(object2 instanceof BasicModuleScript)) continue;
            object = (BasicModuleScript)object2;
            linkedHashMap.put(((BasicModuleScript)object).getModule().getScriptFile().getPath(), (BasicModuleScript)object);
        }
        for (ScriptedModule scriptedModule : this.scriptLoader.getAllModulesByType(ModuleScriptType.BASIC_MODULE)) {
            object = scriptedModule.getScriptFile().getPath();
            if (linkedHashMap.containsKey(object)) {
                BasicModuleScript basicModuleScript = (BasicModuleScript)linkedHashMap.get(object);
                arrayList.add(new BasicModuleScript(scriptedModule, basicModuleScript.isEnabled(), basicModuleScript.getRunningTimeProfile()));
                continue;
            }
            arrayList.add(new BasicModuleScript(scriptedModule));
        }
        return arrayList;
    }
}

