/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.api.events;

import com.subgraph.vega.api.events.EventListenerManager;
import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class NamedEventListenerManager {
    private final Map<String, EventListenerManager> eventManagerMap = new HashMap<String, EventListenerManager>();

    public void addListener(String string, IEventHandler iEventHandler) {
        this.getEventManagerByName(string).addListener(iEventHandler);
    }

    public void fireEvent(String string, IEvent iEvent) {
        this.getEventManagerByName(string).fireEvent(iEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAllKeys(IEvent iEvent) {
        Map<String, EventListenerManager> map = this.eventManagerMap;
        synchronized (map) {
            for (String string : this.eventManagerMap.keySet()) {
                this.eventManagerMap.get(string).fireEvent(iEvent);
            }
        }
    }

    public void removeListener(String string, IEventHandler iEventHandler) {
        this.getEventManagerByName(string).removeListener(iEventHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IEventHandler iEventHandler) {
        Map<String, EventListenerManager> map = this.eventManagerMap;
        synchronized (map) {
            for (EventListenerManager eventListenerManager : this.eventManagerMap.values()) {
                eventListenerManager.removeListener(iEventHandler);
            }
        }
    }

    public Collection<String> getAllKeys() {
        return this.eventManagerMap.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventListenerManager getEventManagerByName(String string) {
        Map<String, EventListenerManager> map = this.eventManagerMap;
        synchronized (map) {
            if (!this.eventManagerMap.containsKey(string)) {
                this.eventManagerMap.put(string, new EventListenerManager());
            }
            return this.eventManagerMap.get(string);
        }
    }
}

