/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.hexeditor;

import com.subgraph.vega.ui.hexeditor.HexEditModelItem;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class HexEditTableEditor
extends EditingSupport {
    private final TableViewer viewer;
    private final int index;

    HexEditTableEditor(TableViewer tableViewer, int n) {
        super((ColumnViewer)tableViewer);
        this.viewer = tableViewer;
        this.index = n;
    }

    protected CellEditor getCellEditor(Object object) {
        return new TextCellEditor((Composite)this.viewer.getTable());
    }

    protected boolean canEdit(Object object) {
        return true;
    }

    protected Object getValue(Object object) {
        if (object instanceof HexEditModelItem) {
            HexEditModelItem hexEditModelItem = (HexEditModelItem)object;
            int n = hexEditModelItem.getByteAt(this.index);
            return String.format("%02X", n);
        }
        return null;
    }

    protected void setValue(Object object, Object object2) {
        if (!(object instanceof HexEditModelItem)) {
            return;
        }
        HexEditModelItem hexEditModelItem = (HexEditModelItem)object;
        try {
            int n = Integer.parseInt(String.valueOf(object2), 16);
            if (n >= 0 && n <= 255) {
                hexEditModelItem.setByteAt(this.index, n);
                this.viewer.refresh(object, true);
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }
}

