/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.hexeditor;

import com.subgraph.vega.ui.hexeditor.HexEditModelItem;

public class HexEditModel {
    static final int DEFAULT_ROW_LENGTH = 16;
    private final byte[] binaryData;
    private final int rowLength;
    private final int lineCount;
    private boolean dirtyFlag;

    public HexEditModel(byte[] byArray) {
        this(byArray, 16, false);
    }

    public HexEditModel(byte[] byArray, int n) {
        this(byArray, n, false);
    }

    public HexEditModel(byte[] byArray, int n, boolean bl) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.binaryData = byArray;
        this.rowLength = n;
        this.lineCount = (byArray.length + (n - 1)) / n;
        this.dirtyFlag = bl;
    }

    byte[] getContent() {
        return this.binaryData;
    }

    boolean isDirty() {
        return this.dirtyFlag;
    }

    int getOffsetForLine(int n) {
        if (n >= this.lineCount) {
            return 0;
        }
        return n * this.rowLength;
    }

    int getLineForOffset(int n) {
        if (n >= this.binaryData.length) {
            return 0;
        }
        return n / this.rowLength;
    }

    int getLineCount() {
        return this.lineCount;
    }

    void markDirty() {
        this.dirtyFlag = true;
    }

    HexEditModel getModelForRowLength(int n) {
        return new HexEditModel(this.binaryData, n, this.dirtyFlag);
    }

    HexEditModelItem getItemForLine(int n) {
        if (n >= this.lineCount) {
            throw new IllegalArgumentException();
        }
        int n2 = this.rowLength * n;
        if (n == this.lineCount - 1) {
            int n3 = this.binaryData.length - n2;
            return new HexEditModelItem(this, n2, this.binaryData, n3, this.rowLength);
        }
        return new HexEditModelItem(this, n2, this.binaryData, this.rowLength, this.rowLength);
    }
}

