/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.tags.taggableeditor;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.WorkspaceCloseEvent;
import com.subgraph.vega.api.model.WorkspaceOpenEvent;
import com.subgraph.vega.api.model.WorkspaceResetEvent;
import com.subgraph.vega.api.model.tags.ITag;
import com.subgraph.vega.api.model.tags.ITagModel;
import com.subgraph.vega.api.model.tags.ITaggable;
import com.subgraph.vega.internal.ui.tags.taggableeditor.TagModifier;
import com.subgraph.vega.internal.ui.tags.taggableeditor.TagTableCheckStateManager;
import com.subgraph.vega.internal.ui.tags.taggableeditor.TagTableContentProvider;
import com.subgraph.vega.internal.ui.tags.taggableeditor.TagTableLabelProvider;
import com.subgraph.vega.internal.ui.tags.taggableeditor.TagTableSearchFilter;
import com.subgraph.vega.ui.tags.Activator;
import com.subgraph.vega.ui.tags.tageditor.TagEditorDialog;
import com.subgraph.vega.ui.tagsl.taggablepopup.ITagModifierValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TaggableEditorDialog
extends TitleAreaDialog
implements ITagModifierValidator {
    protected static final String IStructuredSelection = null;
    private final ITaggable taggable;
    private ITagModel tagModel;
    private IEventHandler workspaceListener;
    private ArrayList<TagModifier> tagList = new ArrayList();
    private TagModifier tagSelected;
    private Composite parentComposite;
    private Text tagFilterText;
    private CheckboxTableViewer tagTableViewer;
    private TagTableCheckStateManager checkStateManager;
    private TagTableSearchFilter tagTableSearchFilter;
    private Button createButton;
    private Button editButton;
    private Text tagNameText;
    private Text tagDescText;
    private ColorSelector nameColorSelector;
    private ColorSelector rowColorSelector;

    public static TaggableEditorDialog createDialog(Shell shell, ITaggable iTaggable) {
        TaggableEditorDialog taggableEditorDialog = new TaggableEditorDialog(shell, iTaggable);
        taggableEditorDialog.initialize();
        taggableEditorDialog.create();
        taggableEditorDialog.getShell().addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 2) {
                    event.doit = false;
                }
            }
        });
        return taggableEditorDialog;
    }

    private TaggableEditorDialog(Shell shell, ITaggable iTaggable) {
        super(shell);
        this.taggable = iTaggable;
        this.workspaceListener = new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof WorkspaceOpenEvent) {
                    TaggableEditorDialog.this.handleWorkspaceOpen((WorkspaceOpenEvent)iEvent);
                } else if (iEvent instanceof WorkspaceCloseEvent) {
                    TaggableEditorDialog.this.handleWorkspaceClose((WorkspaceCloseEvent)iEvent);
                } else if (iEvent instanceof WorkspaceResetEvent) {
                    TaggableEditorDialog.this.handleWorkspaceReset((WorkspaceResetEvent)iEvent);
                }
            }
        };
        this.checkStateManager = new TagTableCheckStateManager();
        this.tagTableSearchFilter = new TagTableSearchFilter();
    }

    private void initialize() {
        IWorkspace iWorkspace = Activator.getDefault().getModel().addWorkspaceListener(this.workspaceListener);
        this.tagModel = iWorkspace.getTagModel();
    }

    private void handleWorkspaceOpen(WorkspaceOpenEvent workspaceOpenEvent) {
        this.tagModel = workspaceOpenEvent.getWorkspace().getTagModel();
    }

    private void handleWorkspaceClose(WorkspaceCloseEvent workspaceCloseEvent) {
        this.tagModel = null;
    }

    private void handleWorkspaceReset(WorkspaceResetEvent workspaceResetEvent) {
        this.tagModel = workspaceResetEvent.getWorkspace().getTagModel();
    }

    public void create() {
        super.create();
        this.setTitle("Select Tags");
        this.setMessage("Tags can be used to signify a result as noteworthy and to simplify searching for it. Select which tags apply to this result.");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.parentComposite = new Composite(composite2, 0);
        this.parentComposite.setLayout((Layout)new GridLayout(1, false));
        this.parentComposite.setLayoutData((Object)new GridData(1808));
        this.createTagsArea(this.parentComposite).setLayoutData((Object)new GridData(1808));
        this.createTagInfoArea(this.parentComposite).setLayoutData((Object)new GridData(1808));
        block0: for (ITag iTag : this.tagModel.getAllTags()) {
            TagModifier tagModifier = new TagModifier(iTag);
            this.tagList.add(tagModifier);
            for (ITag iTag2 : this.taggable.getAllTags()) {
                if (tagModifier.getTagOrig() != iTag2) continue;
                this.checkStateManager.addChecked(tagModifier);
                continue block0;
            }
        }
        this.tagTableViewer.setInput(this.tagList);
        this.setTagSelected(null);
        return composite2;
    }

    protected void okPressed() {
        for (TagModifier object2 : this.tagList) {
            if (!object2.isModified()) continue;
            object2.store(this.tagModel);
        }
        List<TagModifier> list = this.checkStateManager.getCheckedList();
        ArrayList arrayList = new ArrayList(list.size());
        for (TagModifier tagModifier : list) {
            arrayList.add(tagModifier.getTagOrig());
        }
        this.taggable.setTags((Collection)arrayList);
        super.okPressed();
    }

    protected void cancelPressed() {
        int n = 0;
        for (TagModifier tagModifier : this.tagList) {
            if (!tagModifier.isModified()) continue;
            ++n;
        }
        if (n != 0 && !this.confirmLoseTagModifications(n)) {
            return;
        }
        super.cancelPressed();
    }

    public boolean close() {
        if (this.workspaceListener != null) {
            Activator.getDefault().getModel().removeWorkspaceListener(this.workspaceListener);
            this.workspaceListener = null;
        }
        return super.close();
    }

    private GridLayout createGaplessGridLayout(int n, boolean bl) {
        GridLayout gridLayout = new GridLayout(n, bl);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginBottom = 0;
        return gridLayout;
    }

    private Control createTagsArea(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText("Available Tags");
        this.tagFilterText = new Text((Composite)group, 128);
        this.tagFilterText.setLayoutData((Object)new GridData(1808));
        this.tagFilterText.setMessage("type filter text");
        this.tagFilterText.addModifyListener(this.createTagFilterModifyListener());
        GridData gridData = new GridData(4, 0x1000000, true, false, 1, 1);
        Control control = this.createTagTable((Composite)group, gridData, 7);
        control.setLayoutData((Object)gridData);
        this.createTagAreaButtonsControl((Composite)group).setLayoutData((Object)new GridData(131072, 4, false, false, 1, 1));
        return group;
    }

    private ModifyListener createTagFilterModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = TaggableEditorDialog.this.tagFilterText.getText();
                if (!string.isEmpty()) {
                    TaggableEditorDialog.this.tagTableSearchFilter.setMatchFilter(string);
                } else {
                    TaggableEditorDialog.this.tagTableSearchFilter.setMatchFilter(null);
                }
                TaggableEditorDialog.this.tagTableViewer.refresh();
            }
        };
    }

    private Control createTagTable(Composite composite, GridData gridData, int n) {
        this.tagTableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.tagTableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.tagTableViewer.setLabelProvider((IBaseLabelProvider)new TagTableLabelProvider());
        this.tagTableViewer.setContentProvider((IContentProvider)new TagTableContentProvider());
        this.tagTableViewer.addSelectionChangedListener(this.createSelectionChangedListener());
        this.tagTableViewer.setCheckStateProvider((ICheckStateProvider)this.checkStateManager);
        this.tagTableViewer.addCheckStateListener((ICheckStateListener)this.checkStateManager);
        this.tagTableViewer.addFilter((ViewerFilter)this.tagTableSearchFilter);
        gridData.heightHint = this.tagTableViewer.getTable().getItemHeight() * n;
        return this.tagTableViewer.getTable();
    }

    private ISelectionChangedListener createSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                boolean bl = selectionChangedEvent.getSelection().isEmpty();
                TaggableEditorDialog.this.editButton.setEnabled(!bl);
                if (!bl) {
                    TagModifier tagModifier = (TagModifier)((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
                    TaggableEditorDialog.this.setTagSelected(tagModifier);
                }
            }
        };
    }

    private Composite createTagAreaButtonsControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        this.createButton = new Button(composite2, 8);
        this.createButton.setText("Create");
        this.createButton.addSelectionListener(this.createSelectionListenerCreateButton());
        this.editButton = new Button(composite2, 8);
        this.editButton.setText("Edit");
        this.editButton.addSelectionListener(this.createSelectionListenerEditButton());
        this.editButton.setEnabled(false);
        return composite2;
    }

    private SelectionListener createSelectionListenerCreateButton() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TagModifier tagModifier = new TagModifier(TaggableEditorDialog.this.tagModel.createTag());
                TagEditorDialog tagEditorDialog = TagEditorDialog.createDialog(TaggableEditorDialog.this.getShell(), tagModifier, TaggableEditorDialog.this);
                if (tagEditorDialog.open() == 0) {
                    TaggableEditorDialog.this.tagList.add(tagModifier);
                    TaggableEditorDialog.this.tagTableViewer.refresh();
                    TaggableEditorDialog.this.tagTableViewer.setSelection((ISelection)new StructuredSelection((Object)tagModifier));
                    TaggableEditorDialog.this.setTagSelected(tagModifier);
                }
            }
        };
    }

    private SelectionListener createSelectionListenerEditButton() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TagEditorDialog tagEditorDialog;
                TagModifier tagModifier = (TagModifier)((IStructuredSelection)TaggableEditorDialog.this.tagTableViewer.getSelection()).getFirstElement();
                if (tagModifier != null && (tagEditorDialog = TagEditorDialog.createDialog(TaggableEditorDialog.this.getShell(), tagModifier, TaggableEditorDialog.this)).open() == 0) {
                    TaggableEditorDialog.this.tagTableViewer.refresh();
                    TaggableEditorDialog.this.setTagSelected(tagModifier);
                }
            }
        };
    }

    private Group createTagInfoArea(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText("Tag Information");
        this.createTagInfoNameControl((Composite)group).setLayoutData((Object)new GridData(1808));
        this.createTagInfoDescControl((Composite)group).setLayoutData((Object)new GridData(1808));
        this.createTagInfoColorControl((Composite)group).setLayoutData((Object)new GridData(1808));
        return group;
    }

    private Composite createTagInfoNameControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)this.createGaplessGridLayout(2, false));
        Label label = new Label(composite2, 0);
        label.setText("Name:");
        label.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.tagNameText = new Text(composite2, 2052);
        this.tagNameText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.tagNameText.setEnabled(false);
        return composite2;
    }

    private Composite createTagInfoDescControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)this.createGaplessGridLayout(1, false));
        Label label = new Label(composite2, 0);
        label.setText("Description:");
        this.tagDescText = new Text(composite2, 2626);
        FontMetrics fontMetrics = new GC((Drawable)this.tagDescText).getFontMetrics();
        GridData gridData = new GridData(4, 4, true, false, 1, 1);
        gridData.heightHint = fontMetrics.getHeight() * 5;
        this.tagDescText.setLayoutData((Object)gridData);
        this.tagDescText.setEditable(false);
        return composite2;
    }

    private Composite createTagInfoColorControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)this.createGaplessGridLayout(2, false));
        Label label = new Label(composite2, 0);
        label.setText("Name color:");
        this.nameColorSelector = new ColorSelector(composite2);
        this.nameColorSelector.setColorValue(new RGB(0, 0, 0));
        this.nameColorSelector.setEnabled(false);
        label = new Label(composite2, 0);
        label.setText("Row background color:");
        this.rowColorSelector = new ColorSelector(composite2);
        this.rowColorSelector.setColorValue(new RGB(255, 255, 255));
        this.rowColorSelector.setEnabled(false);
        return composite2;
    }

    private RGB tagColorToRgb(int n) {
        return new RGB(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
    }

    private void setTagSelected(TagModifier tagModifier) {
        this.tagSelected = tagModifier;
        if (tagModifier != null) {
            this.tagNameText.setText(tagModifier.getName());
            if (tagModifier.getDescription() != null) {
                this.tagDescText.setText(tagModifier.getDescription());
            } else {
                this.tagDescText.setText("");
            }
            this.nameColorSelector.setColorValue(this.tagColorToRgb(tagModifier.getNameColor()));
            this.rowColorSelector.setColorValue(this.tagColorToRgb(tagModifier.getRowColor()));
        } else {
            this.tagNameText.setText("");
            this.tagDescText.setText("");
            this.nameColorSelector.setColorValue(new RGB(0, 0, 0));
            this.rowColorSelector.setColorValue(new RGB(255, 255, 255));
        }
    }

    private boolean confirmLoseTagModifications(int n) {
        MessageBox messageBox = new MessageBox(this.getShell(), 296);
        messageBox.setText("Warning");
        messageBox.setMessage(String.valueOf(n) + " tags were modified. Proceed without saving?");
        return messageBox.open() != 256;
    }

    @Override
    public String validate(TagModifier tagModifier) {
        String string = tagModifier.getName();
        if (string.isEmpty()) {
            return "Tag name cannot be empty";
        }
        for (TagModifier tagModifier2 : this.tagList) {
            if (tagModifier2 == tagModifier || !tagModifier2.getName().equalsIgnoreCase(string)) continue;
            return "A tag of that name already exists";
        }
        return null;
    }
}

