/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.ui.tags.taggableeditor;

import com.subgraph.vega.api.model.tags.ITag;
import com.subgraph.vega.api.model.tags.ITagModel;

public class TagModifier
implements ITag {
    private ITag tagOrig;
    private String name;
    private String description;
    private int nameColor;
    private int rowColor;
    private boolean isModified;

    public TagModifier(ITag iTag) {
        this.tagOrig = iTag;
        this.name = iTag.getName();
        this.description = iTag.getDescription();
        this.nameColor = iTag.getNameColor();
        this.rowColor = iTag.getRowColor();
        this.isModified = false;
    }

    public ITag getTagOrig() {
        return this.tagOrig;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setName(String string) {
        this.name = string;
        this.isModified = true;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String string) {
        this.description = string;
        this.isModified = true;
    }

    public String getDescription() {
        return this.description;
    }

    public void setNameColor(int n) {
        this.nameColor = n;
        this.isModified = true;
    }

    public int getNameColor() {
        return this.nameColor;
    }

    public void setRowColor(int n) {
        this.rowColor = n;
        this.isModified = true;
    }

    public int getRowColor() {
        return this.rowColor;
    }

    public void store(ITagModel iTagModel) {
        if (this.isModified) {
            ITag iTag = this.tagOrig;
            if (iTag == null) {
                iTag = iTagModel.createTag();
            }
            this.tagOrig.setName(this.name);
            this.tagOrig.setDescription(this.description);
            this.tagOrig.setNameColor(this.nameColor);
            this.tagOrig.setRowColor(this.rowColor);
            if (this.tagOrig != iTag) {
                iTagModel.store(iTag);
                this.tagOrig = iTag;
            }
            this.isModified = false;
        }
    }
}

