/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.parser;

import com.subgraph.vega.api.http.requests.IHttpMessageBuilder;
import com.subgraph.vega.api.http.requests.IHttpResponseBuilder;
import com.subgraph.vega.ui.httpeditor.parser.ParserBase;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.LineParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.CharArrayBuffer;

public class HttpResponseParser
extends ParserBase {
    private final IHttpResponseBuilder builder;
    private final boolean parseInlineEntities;

    public HttpResponseParser(IHttpResponseBuilder iHttpResponseBuilder, boolean bl) {
        this.builder = iHttpResponseBuilder;
        this.parseInlineEntities = bl;
    }

    public void parseResponse(String string) throws UnsupportedEncodingException {
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(0);
        charArrayBuffer.append(string);
        ParserCursor parserCursor = new ParserCursor(0, charArrayBuffer.length());
        BasicLineParser basicLineParser = new BasicLineParser();
        if (this.parseStatusLine((LineParser)basicLineParser, this.builder, charArrayBuffer, parserCursor) < 0) {
            return;
        }
        this.builder.clearHeaders();
        this.parseHeaders((LineParser)basicLineParser, (IHttpMessageBuilder)this.builder, charArrayBuffer, parserCursor);
        if (!parserCursor.atEnd() && this.parseInlineEntities) {
            StringEntity stringEntity = new StringEntity(charArrayBuffer.substring(parserCursor.getPos(), parserCursor.getUpperBound()));
            this.builder.setEntity((HttpEntity)stringEntity);
        }
    }

    public IHttpResponseBuilder getResponseBuilder() {
        return this.builder;
    }

    private int parseStatusLine(LineParser lineParser, IHttpResponseBuilder iHttpResponseBuilder, CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        CharArrayBuffer charArrayBuffer2 = new CharArrayBuffer(0);
        if (this.readLine(charArrayBuffer, parserCursor, charArrayBuffer2) < 1) {
            return -1;
        }
        ParserCursor parserCursor2 = new ParserCursor(0, charArrayBuffer2.length());
        StatusLine statusLine = lineParser.parseStatusLine(charArrayBuffer2, parserCursor2);
        iHttpResponseBuilder.setFromStatusLine(statusLine);
        return 0;
    }
}

