/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.js.formatter;

import com.subgraph.vega.ui.httpeditor.js.formatter.JavascriptFormatterConfig;

public class FormatterState {
    int indentationLevel;
    int indentationBaseline;
    boolean eatNextSpace;
    boolean ifLine;
    boolean varLine;
    boolean varLineTainted;
    boolean varLineReindented;
    boolean inCase;
    boolean inHtmlComment;
    int ternaryDepth;
    Mode mode;
    Mode previousMode;

    FormatterState(Mode mode) {
        this(null, mode, null);
    }

    FormatterState(JavascriptFormatterConfig javascriptFormatterConfig, Mode mode, FormatterState formatterState) {
        this.mode = mode;
        this.varLine = false;
        this.varLineTainted = false;
        this.varLineReindented = false;
        this.ifLine = false;
        this.inCase = false;
        this.eatNextSpace = false;
        this.indentationBaseline = -1;
        this.ternaryDepth = 0;
        if (formatterState != null) {
            this.previousMode = formatterState.mode;
            this.indentationLevel = formatterState.indentationLevel;
            if (formatterState.varLine && formatterState.varLineReindented) {
                ++this.indentationLevel;
            }
        } else {
            this.previousMode = Mode.BLOCK;
            this.indentationLevel = javascriptFormatterConfig == null ? 0 : javascriptFormatterConfig.indentLevel;
        }
    }

    static enum Mode {
        ARRAY_EXPR(true, true),
        ARRAY_INDENTED_EXPR(true, true),
        PAREN_EXPR(false, true),
        DO_BLOCK(false, false),
        BLOCK(false, false),
        OBJECT(false, false);

        final boolean isArray;
        final boolean isExpression;

        private Mode(boolean bl, boolean bl2) {
            this.isArray = bl;
            this.isExpression = bl2;
        }
    }
}

