/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.http;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class HeaderPartitionRule
implements IPredicateRule {
    private static final String SEPARATORS = "()<>@,;:\\\"/[]?={} \t";
    private final IToken token;

    public HeaderPartitionRule(IToken iToken) {
        this.token = iToken;
    }

    public IToken evaluate(ICharacterScanner iCharacterScanner) {
        int n;
        if (!this.parseHeaderName(iCharacterScanner)) {
            return Token.UNDEFINED;
        }
        while ((n = iCharacterScanner.read()) != -1 && n != 13 && n != 10) {
        }
        iCharacterScanner.unread();
        return this.token;
    }

    private boolean parseHeaderName(ICharacterScanner iCharacterScanner) {
        int n;
        if (iCharacterScanner.getColumn() != 0) {
            return false;
        }
        int n2 = 1;
        while ((n = iCharacterScanner.read()) != -1) {
            if (n == 58 && n2 > 1) {
                return true;
            }
            if (!this.isLegalHeaderNameChar(n)) break;
            ++n2;
        }
        this.unread(iCharacterScanner, n2);
        return false;
    }

    private void unread(ICharacterScanner iCharacterScanner, int n) {
        int n2 = 0;
        while (n2 < n) {
            iCharacterScanner.unread();
            ++n2;
        }
    }

    private boolean isLegalHeaderNameChar(int n) {
        return n > 31 && SEPARATORS.indexOf(n) == -1;
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    public IToken evaluate(ICharacterScanner iCharacterScanner, boolean bl) {
        return this.evaluate(iCharacterScanner);
    }
}

