/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.http;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public abstract class AbstractSyntaxRule
implements IRule {
    private final IToken token;
    protected int readCount;

    protected AbstractSyntaxRule(IToken iToken) {
        this.token = iToken;
    }

    protected IToken getSuccessToken() {
        return this.token;
    }

    protected abstract boolean evaluateRule(ICharacterScanner var1);

    public IToken evaluate(ICharacterScanner iCharacterScanner) {
        this.readCount = 0;
        if (this.evaluateRule(iCharacterScanner)) {
            return this.token;
        }
        this.rewind(iCharacterScanner);
        return Token.UNDEFINED;
    }

    private void rewind(ICharacterScanner iCharacterScanner) {
        int n = 0;
        while (n < this.readCount) {
            iCharacterScanner.unread();
            ++n;
        }
    }

    protected boolean matchSingleChar(ICharacterScanner iCharacterScanner, char c) {
        if (iCharacterScanner.read() == c) {
            ++this.readCount;
            return true;
        }
        iCharacterScanner.unread();
        return false;
    }

    protected boolean matchDigits(ICharacterScanner iCharacterScanner) {
        return this.matchAndCountDigits(iCharacterScanner) > 0;
    }

    protected boolean matchDigits(ICharacterScanner iCharacterScanner, int n) {
        return this.matchDigits(iCharacterScanner, n, n);
    }

    protected boolean matchDigits(ICharacterScanner iCharacterScanner, int n, int n2) {
        int n3 = this.matchAndCountDigits(iCharacterScanner);
        return n3 <= n2 && n3 >= n;
    }

    protected int matchAndCountDigits(ICharacterScanner iCharacterScanner) {
        int n;
        int n2 = 0;
        while (this.isDigit(n = iCharacterScanner.read())) {
            ++n2;
            ++this.readCount;
        }
        iCharacterScanner.unread();
        return n2;
    }

    protected void skipWhitespace(ICharacterScanner iCharacterScanner) {
        while (true) {
            int n;
            if (!this.isWhitespace(n = iCharacterScanner.read())) {
                iCharacterScanner.unread();
                return;
            }
            ++this.readCount;
        }
    }

    protected boolean matchWhitespace(ICharacterScanner iCharacterScanner) {
        int n = iCharacterScanner.read();
        ++this.readCount;
        if (!this.isWhitespace(n)) {
            return false;
        }
        while (true) {
            if (!this.isWhitespace(iCharacterScanner.read())) {
                iCharacterScanner.unread();
                return true;
            }
            ++this.readCount;
        }
    }

    protected boolean isDigit(int n) {
        return n >= 48 && n <= 57;
    }

    protected boolean isWhitespace(int n) {
        return n == 32 || n == 10 || n == 13 || n == 9;
    }

    protected boolean isUppercase(int n) {
        return n >= 65 && n <= 90;
    }

    protected boolean isLowercase(int n) {
        return n >= 97 && n <= 122;
    }

    protected boolean isHexDigit(int n) {
        return this.isDigit(n) || n >= 97 && n <= 102 || n >= 65 && n <= 70;
    }
}

