/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.http;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

abstract class AbstractStartLinePartitionRule
implements IPredicateRule {
    private final IToken token;
    private ICharacterScanner scanner;

    AbstractStartLinePartitionRule(IToken iToken) {
        this.token = iToken;
    }

    protected int nextChar() {
        return this.scanner.read();
    }

    protected void unread() {
        this.scanner.unread();
    }

    protected boolean isFirstColumn() {
        return this.scanner.getColumn() == 0;
    }

    protected void unread(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.scanner.unread();
            ++n2;
        }
    }

    protected boolean detectSingleSpace() {
        if (this.nextChar() == 32) {
            return true;
        }
        this.unread();
        return false;
    }

    protected String parseWord() {
        return this.parseUntilSpace(true);
    }

    protected String parseUntilSpace(boolean bl) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = this.nextChar()) != -1) {
            if (n == 10 || n == 13 || n == 32) {
                this.unread();
                return stringBuilder.toString();
            }
            stringBuilder.append((char)n);
        }
        if (bl) {
            return stringBuilder.toString();
        }
        this.unread(stringBuilder.length());
        return "";
    }

    protected String parseUntilEOL(boolean bl) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = this.nextChar()) != -1) {
            if (n == 10) {
                this.unread();
                return stringBuilder.toString();
            }
            if (n == 13) {
                if (this.nextChar() != 10) continue;
                this.unread(2);
                return stringBuilder.toString();
            }
            stringBuilder.append((char)n);
        }
        if (bl) {
            return stringBuilder.toString();
        }
        this.unread(stringBuilder.length());
        return "";
    }

    protected boolean detectEOL() {
        int n = this.nextChar();
        if (n == 10) {
            return true;
        }
        if (n == 13) {
            if (this.nextChar() == 10) {
                return true;
            }
            this.unread();
        }
        this.unread();
        return false;
    }

    protected abstract boolean doEvaluate();

    public IToken evaluate(ICharacterScanner iCharacterScanner) {
        if (iCharacterScanner.getColumn() != 0) {
            return Token.UNDEFINED;
        }
        this.scanner = iCharacterScanner;
        if (this.doEvaluate()) {
            return this.token;
        }
        return Token.UNDEFINED;
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    public IToken evaluate(ICharacterScanner iCharacterScanner, boolean bl) {
        return this.evaluate(iCharacterScanner);
    }

    protected boolean isHttpVersion(String string) {
        if (string == null || !string.toUpperCase().startsWith("HTTP/")) {
            return false;
        }
        return this.isVersionDigits(string.substring(5));
    }

    private boolean isVersionDigits(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 2) {
            return false;
        }
        return this.isInteger(stringArray[0]) && this.isInteger(stringArray[1]);
    }

    protected boolean isInteger(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

