/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.highlights;

import com.subgraph.vega.ui.httpeditor.highlights.RegionInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jface.text.IRegion;

public class MatchingRegions {
    private final String annotationType;
    private final SortedSet<IRegion> regionsMatched;
    private final List<RegionInfo> regionInfo;
    private int currentIndex;
    private boolean isLocked;

    public MatchingRegions(String string) {
        this.annotationType = string;
        this.regionsMatched = new TreeSet<IRegion>(this.createRegionComparator());
        this.regionInfo = new ArrayList<RegionInfo>();
        this.reset();
    }

    private Comparator<IRegion> createRegionComparator() {
        return new Comparator<IRegion>(){

            @Override
            public int compare(IRegion iRegion, IRegion iRegion2) {
                if (iRegion.getOffset() == iRegion2.getOffset() && iRegion.getLength() == iRegion2.getLength()) {
                    return 0;
                }
                if (iRegion.getOffset() == iRegion2.getOffset()) {
                    if (iRegion.getLength() < iRegion2.getLength()) {
                        return -1;
                    }
                    return 1;
                }
                if (iRegion.getOffset() < iRegion2.getOffset()) {
                    return -1;
                }
                return 1;
            }
        };
    }

    public void reset() {
        this.regionsMatched.clear();
        this.regionInfo.clear();
        this.currentIndex = 0;
        this.isLocked = false;
    }

    public List<RegionInfo> getAllRegions() {
        this.lockRegions();
        return Collections.unmodifiableList(this.regionInfo);
    }

    private void lockRegions() {
        if (this.isLocked) {
            return;
        }
        this.isLocked = true;
        for (IRegion iRegion : this.regionsMatched) {
            this.regionInfo.add(new RegionInfo(iRegion, this.annotationType));
        }
    }

    public void addRegions(List<IRegion> list) {
        if (this.isLocked) {
            throw new IllegalStateException("Cannot add items to locked matching regions");
        }
        this.regionsMatched.addAll(list);
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public int getMatchCount() {
        this.lockRegions();
        return this.regionInfo.size();
    }

    public boolean hasPrevious() {
        this.lockRegions();
        return this.currentIndex > 0;
    }

    public boolean hasNext() {
        this.lockRegions();
        return this.regionInfo.size() > this.currentIndex + 1;
    }

    public RegionInfo getFirstRegion() {
        this.lockRegions();
        if (this.regionInfo.isEmpty()) {
            throw new RuntimeException("Trying to get first match on empty set");
        }
        this.currentIndex = 0;
        return this.regionInfo.get(0);
    }

    public RegionInfo getNextRegion() {
        this.lockRegions();
        if (!this.hasNext()) {
            throw new RuntimeException("No next region");
        }
        ++this.currentIndex;
        return this.regionInfo.get(this.currentIndex);
    }

    public RegionInfo getPreviousRegion() {
        this.lockRegions();
        if (!this.hasPrevious()) {
            throw new RuntimeException("No previous highlight");
        }
        --this.currentIndex;
        return this.regionInfo.get(this.currentIndex);
    }
}

