/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.annotations;

import com.subgraph.vega.ui.httpeditor.annotations.EmbedAnnotation;
import com.subgraph.vega.ui.httpeditor.annotations.ISelfDrawingAnnotation;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ImageAnnotation
extends EmbedAnnotation
implements ISelfDrawingAnnotation {
    public static final String TYPE = "com.subgraph.vega.ui.httpviewer.annotation.image";
    private final Image image;

    public ImageAnnotation(Image image) {
        super(TYPE, image.getBounds().height);
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    @Override
    public void draw(GC gC, StyledText styledText, int n, int n2) {
        if (gC != null) {
            if (this.image != null) {
                Color color;
                Point point = styledText.getLocationAtOffset(n);
                if (n2 > 0) {
                    color = styledText.getLocationAtOffset(n + n2);
                    if (point.x > color.x) {
                        point.x = 0;
                        point.y = color.y;
                    }
                }
                color = gC.getForeground();
                Color color2 = gC.getBackground();
                gC.setForeground(styledText.getBackground());
                gC.setBackground(styledText.getBackground());
                Rectangle rectangle = this.image.getBounds();
                gC.fillRectangle(new Rectangle(point.x, point.y, rectangle.width, rectangle.height));
                gC.setForeground(color);
                gC.setBackground(color2);
                gC.drawImage(this.image, point.x, point.y);
            }
        } else {
            styledText.redrawRange(n, n2, true);
        }
    }
}

