/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor;

import com.subgraph.vega.api.http.requests.IHttpRequestBuilder;
import com.subgraph.vega.api.http.requests.IHttpResponseBuilder;
import com.subgraph.vega.api.model.alerts.IScanAlertHighlight;
import com.subgraph.vega.ui.httpeditor.BinaryEntityManager;
import com.subgraph.vega.ui.httpeditor.Colors;
import com.subgraph.vega.ui.httpeditor.Configuration;
import com.subgraph.vega.ui.httpeditor.HttpMessageDocument;
import com.subgraph.vega.ui.httpeditor.HttpMessageDocumentFactory;
import com.subgraph.vega.ui.httpeditor.ProjectionAnnotationAccess;
import com.subgraph.vega.ui.httpeditor.TextViewerAction;
import com.subgraph.vega.ui.httpeditor.highlights.CornerLayout;
import com.subgraph.vega.ui.httpeditor.highlights.CornerLayoutData;
import com.subgraph.vega.ui.httpeditor.highlights.HighlightBar;
import com.subgraph.vega.ui.httpeditor.search.SearchBar;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class HttpMessageEditor
extends Composite {
    private final Colors colors;
    private final Composite rootComposite;
    private final SashForm sashForm;
    private final ProjectionViewer viewer;
    private final AnnotationModel viewerAnnotationModel;
    private final ProjectionSupport projectionSupport;
    private final HttpMessageDocumentFactory messageDocumentFactory;
    private final HighlightBar highlightBar;
    private final BinaryEntityManager bem;
    private HttpMessageDocument activeDocument;
    private boolean urlDecode;

    public HttpMessageEditor(Composite composite) {
        super(composite, 0);
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.sashForm = new SashForm((Composite)this, 512);
        this.rootComposite = this.createRootComposite((Composite)this.sashForm);
        this.colors = new Colors(this.getDisplay());
        this.viewerAnnotationModel = new AnnotationModel();
        this.viewer = this.createSourceViewer(this.rootComposite, this.viewerAnnotationModel);
        this.viewer.getTextWidget().setWrapIndent(20);
        this.viewer.configure((SourceViewerConfiguration)new Configuration(this.colors));
        this.createViewerActions((TextViewer)this.viewer);
        this.projectionSupport = new ProjectionSupport(this.viewer, (IAnnotationAccess)new ProjectionAnnotationAccess(), (ISharedTextColors)this.colors);
        this.projectionSupport.install();
        this.messageDocumentFactory = new HttpMessageDocumentFactory();
        SearchBar searchBar = new SearchBar(this, this.viewer, this.colors);
        searchBar.setLayoutData(CornerLayoutData.createTopRight());
        this.highlightBar = new HighlightBar(this, this.viewer, this.colors);
        this.highlightBar.setLayoutData(CornerLayoutData.createBottomRight());
        this.setLayout(new CornerLayout(this.viewer.getTextWidget()));
        this.layout(true);
        this.rootComposite.layout(true, true);
        this.bem = new BinaryEntityManager((SourceViewer)this.viewer, this.sashForm, this.rootComposite);
    }

    private Composite createRootComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setBackground(this.getDisplay().getSystemColor(1));
        return composite2;
    }

    private ProjectionViewer createSourceViewer(Composite composite, AnnotationModel annotationModel) {
        CompositeRuler compositeRuler = new CompositeRuler();
        ProjectionViewer projectionViewer = new ProjectionViewer(composite, (IVerticalRuler)compositeRuler, null, false, 770);
        TextViewerUndoManager textViewerUndoManager = new TextViewerUndoManager(8);
        textViewerUndoManager.connect((ITextViewer)projectionViewer);
        GridData gridData = new GridData(4, 4, true, true);
        projectionViewer.getControl().setLayoutData((Object)gridData);
        return projectionViewer;
    }

    private void createViewerActions(TextViewer textViewer) {
        final ArrayList<TextViewerAction> arrayList = new ArrayList<TextViewerAction>();
        MenuManager menuManager = new MenuManager();
        arrayList.add(this.createMenuAction(menuManager, textViewer, 3, "Cut"));
        arrayList.add(this.createMenuAction(menuManager, textViewer, 4, "Copy"));
        arrayList.add(this.createMenuAction(menuManager, textViewer, 5, "Paste"));
        arrayList.add(this.createMenuAction(menuManager, textViewer, 1, "Undo"));
        arrayList.add(this.createMenuAction(menuManager, textViewer, 2, "Redo"));
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                for (TextViewerAction textViewerAction : arrayList) {
                    textViewerAction.update();
                }
            }
        });
        Menu menu = menuManager.createContextMenu((Control)textViewer.getTextWidget());
        textViewer.getTextWidget().setMenu(menu);
    }

    private TextViewerAction createMenuAction(MenuManager menuManager, TextViewer textViewer, int n, String string) {
        TextViewerAction textViewerAction = new TextViewerAction((ITextViewer)textViewer, n);
        textViewerAction.setText(string);
        menuManager.add((IAction)textViewerAction);
        return textViewerAction;
    }

    public void dispose() {
        this.colors.dispose();
        this.bem.dispose();
        super.dispose();
    }

    public void addAlertHighlights(Collection<IScanAlertHighlight> collection) {
        this.highlightBar.addAlertHighlights(collection);
    }

    public void displayAlertHighlights() {
        this.highlightBar.displayHighlights();
    }

    public void clearContent() {
        this.bem.clear();
        this.activeDocument = null;
        this.highlightBar.clearHighlights();
        this.viewer.unconfigure();
        this.viewer.configure((SourceViewerConfiguration)new Configuration(this.colors));
        this.viewer.setDocument((IDocument)new Document());
    }

    public String getContent() {
        if (this.activeDocument == null) {
            return "";
        }
        return this.activeDocument.getHeaderSectionText();
    }

    public HttpEntity getEntityContent() {
        if (this.activeDocument == null || this.activeDocument.getMessageEntity().isEmptyEntity()) {
            return null;
        }
        if (!this.isEntityContentDirty()) {
            return this.activeDocument.getMessageEntity().getEntity();
        }
        if (this.activeDocument.getMessageEntity().isAsciiEntity()) {
            return this.getDirtyAsciiEntityContent();
        }
        return this.getDirtyBinaryEntityContent();
    }

    private HttpEntity getDirtyAsciiEntityContent() {
        try {
            StringEntity stringEntity = new StringEntity(this.activeDocument.getBodySectionText());
            stringEntity.setContentType(this.activeDocument.getMessageEntity().getContentType());
            stringEntity.setContentEncoding(this.activeDocument.getMessageEntity().getContentEncoding());
            return stringEntity;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unsupported encoding creating new ascii entity", unsupportedEncodingException);
        }
    }

    private HttpEntity getDirtyBinaryEntityContent() {
        ByteArrayEntity byteArrayEntity = new ByteArrayEntity(this.bem.getContent());
        byteArrayEntity.setContentType(this.activeDocument.getMessageEntity().getContentType());
        byteArrayEntity.setContentEncoding(this.activeDocument.getMessageEntity().getContentType());
        return byteArrayEntity;
    }

    public void setDecodeUrlEncoding(boolean bl) {
        this.urlDecode = bl;
        if (this.activeDocument != null) {
            this.activeDocument.setHeaderDecodeState(bl);
        }
    }

    public void setEditable(boolean bl) {
        this.viewer.setEditable(bl);
    }

    public void setDisplayImages(boolean bl) {
        this.bem.displayImages(bl);
    }

    public void setDisplayImagesAsHex(boolean bl) {
        this.bem.displayImagesAsHex(bl);
    }

    public void setWordwrapLines(boolean bl) {
        this.viewer.getTextWidget().setWordWrap(bl);
    }

    public void displayHttpRequest(HttpRequest httpRequest) {
        this.clearContent();
        this.activeDocument = this.messageDocumentFactory.createForRequest(httpRequest);
        this.displayNewDocument();
    }

    public void displayHttpRequest(IHttpRequestBuilder iHttpRequestBuilder) {
        this.clearContent();
        this.activeDocument = this.messageDocumentFactory.createForRequest(iHttpRequestBuilder);
        this.displayNewDocument();
    }

    public void displayHttpResponse(HttpResponse httpResponse) {
        this.clearContent();
        this.activeDocument = this.messageDocumentFactory.createForResponse(httpResponse);
        this.displayNewDocument();
    }

    public void displayHttpResponse(IHttpResponseBuilder iHttpResponseBuilder) {
        this.clearContent();
        this.activeDocument = this.messageDocumentFactory.createForResponse(iHttpResponseBuilder);
        this.displayNewDocument();
    }

    public boolean isEntityContentDirty() {
        if (this.activeDocument == null || this.activeDocument.getMessageEntity().isEmptyEntity()) {
            return false;
        }
        if (this.activeDocument.getMessageEntity().isAsciiEntity()) {
            return this.activeDocument.isBodyEntityDirty();
        }
        return this.bem.isContentDirty();
    }

    private void displayNewDocument() {
        if (this.activeDocument == null) {
            return;
        }
        AnnotationModel annotationModel = new AnnotationModel();
        this.viewer.disableProjection();
        boolean bl = this.viewer.getTextWidget().getWordWrap();
        if (bl) {
            this.viewer.getTextWidget().setWordWrap(false);
        }
        this.viewer.setDocument(this.activeDocument.getDocument(), (IAnnotationModel)annotationModel);
        if (bl) {
            this.viewer.getTextWidget().setWordWrap(true);
        }
        this.viewer.enableProjection();
        this.activeDocument.addProjectionAnnotations(this.viewer.getProjectionAnnotationModel());
        this.bem.displayNewDocument(this.activeDocument);
        this.activeDocument.setHeaderDecodeState(this.urlDecode);
    }
}

