/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor;

import com.subgraph.vega.api.http.requests.IHttpRequestBuilder;
import com.subgraph.vega.api.http.requests.IHttpResponseBuilder;
import com.subgraph.vega.ui.httpeditor.DefaultTextEntityRenderer;
import com.subgraph.vega.ui.httpeditor.HttpHeaderTextRenderer;
import com.subgraph.vega.ui.httpeditor.HttpMessageDocument;
import com.subgraph.vega.ui.httpeditor.HttpMessageEntity;
import com.subgraph.vega.ui.httpeditor.ITextEntityRenderer;
import com.subgraph.vega.ui.httpeditor.html.HtmlTextEntityRenderer;
import com.subgraph.vega.ui.httpeditor.http.HeaderPartitionRule;
import com.subgraph.vega.ui.httpeditor.http.RequestLinePartitionRule;
import com.subgraph.vega.ui.httpeditor.http.ResponseLinePartitionRule;
import com.subgraph.vega.ui.httpeditor.js.JavascriptTextEntityRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;

public class HttpMessageDocumentFactory {
    private static final int MAX_LONG_LINE = 200;
    private static final int ABSOLUTE_MAX_LONG_LINE = 220;
    public static final String PARTITION_REQUEST_LINE = "http-request-line";
    public static final String PARTITION_RESPONSE_LINE = "http-response-line";
    public static final String PARTITION_MESSAGE_HEADER = "http-header";
    public static final String[] PARTITION_TYPES = new String[]{"http-request-line", "http-response-line", "http-header"};
    public static final ITextEntityRenderer[] ENTITY_RENDERERS = new ITextEntityRenderer[]{new HtmlTextEntityRenderer(), new JavascriptTextEntityRenderer(), new DefaultTextEntityRenderer()};
    private final HttpHeaderTextRenderer messageRenderer = new HttpHeaderTextRenderer();

    HttpMessageDocument createForRequest(HttpRequest httpRequest) {
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntity httpEntity = ((HttpEntityEnclosingRequest)httpRequest).getEntity();
            return this.createForText(this.messageRenderer.getRequestAsText(httpRequest), httpEntity);
        }
        return this.createForText(this.messageRenderer.getRequestAsText(httpRequest));
    }

    HttpMessageDocument createForResponse(HttpResponse httpResponse) {
        return this.createForText(this.messageRenderer.getResponseAsText(httpResponse), httpResponse.getEntity());
    }

    HttpMessageDocument createForRequest(IHttpRequestBuilder iHttpRequestBuilder) {
        return this.createForText(this.messageRenderer.getRequestAsText(iHttpRequestBuilder), iHttpRequestBuilder.getEntity());
    }

    HttpMessageDocument createForResponse(IHttpResponseBuilder iHttpResponseBuilder) {
        return this.createForText(this.messageRenderer.getResponseAsText(iHttpResponseBuilder), iHttpResponseBuilder.getEntity());
    }

    private HttpMessageDocument createForText(String string) {
        return this.createForText(string, null);
    }

    private HttpMessageDocument createForText(String string, HttpEntity httpEntity) {
        HttpMessageEntity httpMessageEntity = HttpMessageEntity.createFromEntity(httpEntity);
        if (httpMessageEntity.isAsciiEntity()) {
            ITextEntityRenderer iTextEntityRenderer = this.getTextEntityRendererForType(httpMessageEntity.getContentType());
            return this.createForHeaderTextWithRenderer(string, httpMessageEntity, iTextEntityRenderer);
        }
        return this.createForHeaderTextWithRenderer(string, httpMessageEntity, null);
    }

    private HttpMessageDocument createForHeaderTextWithRenderer(String string, HttpMessageEntity httpMessageEntity, ITextEntityRenderer iTextEntityRenderer) {
        String string2 = this.getBodyText(httpMessageEntity, iTextEntityRenderer);
        IDocument iDocument = this.createDocument(string, string2, iTextEntityRenderer);
        return new HttpMessageDocument(iDocument, httpMessageEntity);
    }

    private String getBodyText(HttpMessageEntity httpMessageEntity, ITextEntityRenderer iTextEntityRenderer) {
        if (!httpMessageEntity.isAsciiEntity() || iTextEntityRenderer == null || httpMessageEntity.getTextData().isEmpty()) {
            return "";
        }
        String string = iTextEntityRenderer.formatText(httpMessageEntity.getTextData());
        return this.longLineFormatter(string, iTextEntityRenderer.getLineSplitChars());
    }

    private String longLineFormatter(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            ++n;
            char c = string.charAt(n2);
            stringBuilder.append(c);
            if (c == '\n') {
                n = 0;
            }
            if (n > 220 || n > 200 && string2.indexOf(c) != -1) {
                stringBuilder.append("\n");
                n = 0;
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    private ITextEntityRenderer getTextEntityRendererForType(String string) {
        ITextEntityRenderer[] iTextEntityRendererArray = ENTITY_RENDERERS;
        int n = ENTITY_RENDERERS.length;
        int n2 = 0;
        while (n2 < n) {
            ITextEntityRenderer iTextEntityRenderer = iTextEntityRendererArray[n2];
            if (iTextEntityRenderer.matchContentType(string.toLowerCase())) {
                return iTextEntityRenderer;
            }
            ++n2;
        }
        return new DefaultTextEntityRenderer();
    }

    private IDocument createDocument(String string, String string2, ITextEntityRenderer iTextEntityRenderer) {
        IDocument iDocument = this.createEmptyDocument(iTextEntityRenderer);
        iDocument.addPositionCategory("__section_category");
        iDocument.addPositionUpdater((IPositionUpdater)new DefaultPositionUpdater("__section_category"));
        if (string2 != null && !string2.isEmpty()) {
            iDocument.set(String.valueOf(string) + string2);
            this.addSectionPosition(iDocument, 0, string.length());
            this.addSectionPosition(iDocument, string.length(), string2.length());
        } else {
            iDocument.set(string);
            this.addSectionPosition(iDocument, 0, string.length());
        }
        return iDocument;
    }

    private void addSectionPosition(IDocument iDocument, int n, int n2) {
        try {
            iDocument.addPosition("__section_category", new Position(n, n2));
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalStateException(badLocationException);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            throw new IllegalStateException(badPositionCategoryException);
        }
    }

    private IDocument createEmptyDocument(ITextEntityRenderer iTextEntityRenderer) {
        Document document = new Document();
        IDocumentPartitioner iDocumentPartitioner = this.createPartitioner(iTextEntityRenderer);
        document.setDocumentPartitioner(iDocumentPartitioner);
        iDocumentPartitioner.connect((IDocument)document);
        return document;
    }

    private IDocumentPartitioner createPartitioner(ITextEntityRenderer iTextEntityRenderer) {
        RuleBasedPartitionScanner ruleBasedPartitionScanner = new RuleBasedPartitionScanner();
        ruleBasedPartitionScanner.setPredicateRules(this.createRules(iTextEntityRenderer));
        if (iTextEntityRenderer != null && iTextEntityRenderer.getDefaultPartitionType() != null) {
            ruleBasedPartitionScanner.setDefaultReturnToken((IToken)new Token((Object)iTextEntityRenderer.getDefaultPartitionType()));
        }
        return new FastPartitioner((IPartitionTokenScanner)ruleBasedPartitionScanner, this.getPartitionTypes(iTextEntityRenderer));
    }

    private IPredicateRule[] createRules(ITextEntityRenderer iTextEntityRenderer) {
        ArrayList<IPredicateRule> arrayList = new ArrayList<IPredicateRule>();
        this.addHeaderPartitionRules(arrayList);
        if (iTextEntityRenderer != null) {
            iTextEntityRenderer.addPartitionScannerRules(arrayList);
        }
        return arrayList.toArray(new IPredicateRule[0]);
    }

    private void addHeaderPartitionRules(List<IPredicateRule> list) {
        list.add(new RequestLinePartitionRule((IToken)new Token((Object)PARTITION_REQUEST_LINE)));
        list.add(new ResponseLinePartitionRule((IToken)new Token((Object)PARTITION_RESPONSE_LINE)));
        list.add(new HeaderPartitionRule((IToken)new Token((Object)PARTITION_MESSAGE_HEADER)));
    }

    private String[] getPartitionTypes(ITextEntityRenderer iTextEntityRenderer) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(PARTITION_TYPES));
        if (iTextEntityRenderer != null) {
            arrayList.addAll(iTextEntityRenderer.getPartitionTypes());
        }
        return arrayList.toArray(new String[0]);
    }
}

