/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor;

import com.subgraph.vega.api.http.requests.IHttpHeaderBuilder;
import com.subgraph.vega.api.http.requests.IHttpMessageBuilder;
import com.subgraph.vega.api.http.requests.IHttpRequestBuilder;
import com.subgraph.vega.api.http.requests.IHttpResponseBuilder;
import org.apache.http.Header;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;

public class HttpHeaderTextRenderer {
    public String getRequestAsText(HttpRequest httpRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        this.renderRequestLine(stringBuilder, httpRequest);
        this.renderAllHeaders(stringBuilder, (HttpMessage)httpRequest);
        return stringBuilder.toString();
    }

    public String getRequestAsText(IHttpRequestBuilder iHttpRequestBuilder) {
        StringBuilder stringBuilder = new StringBuilder();
        this.renderRequestLine(stringBuilder, iHttpRequestBuilder);
        this.renderAllHeaders(stringBuilder, (IHttpMessageBuilder)iHttpRequestBuilder);
        return stringBuilder.toString();
    }

    public String getResponseAsText(HttpResponse httpResponse) {
        StringBuilder stringBuilder = new StringBuilder();
        this.renderStatusLine(stringBuilder, httpResponse);
        this.renderAllHeaders(stringBuilder, (HttpMessage)httpResponse);
        return stringBuilder.toString();
    }

    public String getResponseAsText(IHttpResponseBuilder iHttpResponseBuilder) {
        StringBuilder stringBuilder = new StringBuilder();
        this.renderStatusLine(stringBuilder, iHttpResponseBuilder);
        this.renderAllHeaders(stringBuilder, (IHttpMessageBuilder)iHttpResponseBuilder);
        return stringBuilder.toString();
    }

    private void renderRequestLine(StringBuilder stringBuilder, HttpRequest httpRequest) {
        stringBuilder.append(httpRequest.getRequestLine().toString());
        stringBuilder.append('\n');
    }

    private void renderRequestLine(StringBuilder stringBuilder, IHttpRequestBuilder iHttpRequestBuilder) {
        String string = iHttpRequestBuilder.getRequestLine();
        if (string != null) {
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
    }

    private void renderStatusLine(StringBuilder stringBuilder, HttpResponse httpResponse) {
        stringBuilder.append(httpResponse.getStatusLine().toString());
        stringBuilder.append('\n');
    }

    private void renderStatusLine(StringBuilder stringBuilder, IHttpResponseBuilder iHttpResponseBuilder) {
        stringBuilder.append(iHttpResponseBuilder.getStatusLine().toString());
        stringBuilder.append('\n');
    }

    private void renderAllHeaders(StringBuilder stringBuilder, HttpMessage httpMessage) {
        Header[] headerArray = httpMessage.getAllHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            this.renderHeader(stringBuilder, header);
            ++n2;
        }
        stringBuilder.append('\n');
    }

    private void renderAllHeaders(StringBuilder stringBuilder, IHttpMessageBuilder iHttpMessageBuilder) {
        IHttpHeaderBuilder[] iHttpHeaderBuilderArray = iHttpMessageBuilder.getHeaders();
        int n = iHttpHeaderBuilderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IHttpHeaderBuilder iHttpHeaderBuilder = iHttpHeaderBuilderArray[n2];
            this.renderHeader(stringBuilder, iHttpHeaderBuilder);
            ++n2;
        }
        stringBuilder.append('\n');
    }

    private void renderHeader(StringBuilder stringBuilder, Header header) {
        stringBuilder.append(header.getName());
        stringBuilder.append(": ");
        stringBuilder.append(header.getValue());
        stringBuilder.append("\n");
    }

    private void renderHeader(StringBuilder stringBuilder, IHttpHeaderBuilder iHttpHeaderBuilder) {
        stringBuilder.append(iHttpHeaderBuilder.getName());
        stringBuilder.append(": ");
        stringBuilder.append(iHttpHeaderBuilder.getValue());
        stringBuilder.append("\n");
    }
}

