/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor;

import com.subgraph.vega.ui.httpeditor.Colors;
import com.subgraph.vega.ui.httpeditor.html.TagScanner;
import com.subgraph.vega.ui.httpeditor.http.HttpHeaderScanner;
import com.subgraph.vega.ui.httpeditor.http.RequestLineScanner;
import com.subgraph.vega.ui.httpeditor.http.ResponseLineScanner;
import com.subgraph.vega.ui.httpeditor.js.JavascriptScanner;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.RGB;

public class Configuration
extends SourceViewerConfiguration {
    private final Colors colors;
    private final IPresentationReconciler reconciler;

    Configuration(Colors colors) {
        this.colors = colors;
        this.reconciler = this.createReconciler();
    }

    private IPresentationReconciler createReconciler() {
        PresentationReconciler presentationReconciler = new PresentationReconciler();
        this.addDamagerRepairer(presentationReconciler, "http-request-line", (ITokenScanner)new RequestLineScanner(this.colors));
        this.addDamagerRepairer(presentationReconciler, "http-response-line", (ITokenScanner)new ResponseLineScanner(this.colors));
        this.addDamagerRepairer(presentationReconciler, "http-header", (ITokenScanner)new HttpHeaderScanner(this.colors));
        this.addDamagerRepairer(presentationReconciler, "js_default", (ITokenScanner)new JavascriptScanner(this.colors));
        this.addDamagerRepairer(presentationReconciler, Colors.MULTI_LINE_COMMENT, "js_multiline_comment");
        this.addDamagerRepairer(presentationReconciler, "html_start_tag", (ITokenScanner)new TagScanner(this.colors));
        this.addDamagerRepairer(presentationReconciler, "html_end_tag", (ITokenScanner)new TagScanner(this.colors));
        this.addDamagerRepairer(presentationReconciler, Colors.MULTI_LINE_COMMENT, "html_comment");
        this.addDamagerRepairer(presentationReconciler, Colors.MULTI_LINE_COMMENT, "html_doctype");
        this.addDamagerRepairer(presentationReconciler, Colors.OTHER, "__dftl_partition_content_type");
        return presentationReconciler;
    }

    private void addDamagerRepairer(PresentationReconciler presentationReconciler, String string, ITokenScanner iTokenScanner) {
        DefaultDamagerRepairer defaultDamagerRepairer = new DefaultDamagerRepairer(iTokenScanner);
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, string);
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, string);
    }

    private void addDamagerRepairer(PresentationReconciler presentationReconciler, RGB rGB, String string) {
        TextAttribute textAttribute = new TextAttribute(this.colors.get(rGB));
        this.addDamagerRepairer(presentationReconciler, string, (ITokenScanner)new SingleTokenScanner(textAttribute));
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer iSourceViewer) {
        return this.reconciler;
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute textAttribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)textAttribute));
        }
    }
}

