/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.urls;

import com.subgraph.vega.api.analysis.IContentAnalyzer;
import com.subgraph.vega.api.crawler.ICrawlerResponseProcessor;
import com.subgraph.vega.api.crawler.IWebCrawler;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.api.model.web.IWebHost;
import com.subgraph.vega.api.model.web.IWebModel;
import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.api.scanner.IPathState;
import com.subgraph.vega.api.scanner.IScannerConfig;
import com.subgraph.vega.api.scanner.modules.IBasicModuleScript;
import com.subgraph.vega.api.util.VegaURI;
import com.subgraph.vega.impl.scanner.handlers.DirectoryProcessor;
import com.subgraph.vega.impl.scanner.handlers.FileProcessor;
import com.subgraph.vega.impl.scanner.handlers.UnknownProcessor;
import com.subgraph.vega.impl.scanner.state.PathState;
import com.subgraph.vega.impl.scanner.state.PathStateManager;
import com.subgraph.vega.impl.scanner.urls.ResponseAnalyzer;
import com.subgraph.vega.impl.scanner.urls.UriFilter;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.HttpHost;
import org.apache.http.client.utils.URLEncodedUtils;

public class UriParser {
    private final IWorkspace workspace;
    private final ICrawlerResponseProcessor directoryProcessor;
    private final ICrawlerResponseProcessor fileProcessor;
    private final ICrawlerResponseProcessor unknownProcessor;
    private final PathStateManager pathStateManager;

    public UriParser(IScannerConfig iScannerConfig, List<IBasicModuleScript> list, IWorkspace iWorkspace, IWebCrawler iWebCrawler, UriFilter uriFilter, IContentAnalyzer iContentAnalyzer, IScanInstance iScanInstance, boolean bl) {
        this.workspace = iWorkspace;
        this.directoryProcessor = new DirectoryProcessor();
        this.fileProcessor = new FileProcessor();
        this.unknownProcessor = new UnknownProcessor();
        this.pathStateManager = new PathStateManager(iScannerConfig, list, iWorkspace, iWebCrawler, new ResponseAnalyzer(iScannerConfig, iContentAnalyzer, this, uriFilter, bl), iScanInstance, bl);
    }

    public void updateInjectionModules(List<IBasicModuleScript> list) {
        this.pathStateManager.setInjectionModules(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPathState processUri(VegaURI vegaURI) {
        Object object;
        IWebPath iWebPath;
        IWebHost iWebHost = this.getWebHost(vegaURI.getTargetHost());
        IWebPath iWebPath2 = iWebPath = iWebHost.getRootPath();
        boolean bl = vegaURI.getPath().endsWith("/");
        String[] stringArray = vegaURI.getPath().split("/");
        IWebPath iWebPath3 = null;
        int n = 1;
        while (n < stringArray.length) {
            object = iWebPath2;
            synchronized (object) {
                iWebPath3 = iWebPath2.getChildPath(stringArray[n]);
                if (iWebPath3 == null) {
                    iWebPath3 = iWebPath2.addChildPath(stringArray[n]);
                }
                this.processPath(iWebPath3, vegaURI, n == stringArray.length - 1, bl);
            }
            iWebPath2 = iWebPath3;
            ++n;
        }
        if (iWebPath2 == iWebPath && vegaURI.getQuery() != null) {
            PathState pathState = this.pathStateManager.getStateForPath(iWebPath);
            object = this.pathStateManager;
            synchronized (object) {
                pathState.maybeAddParameters(URLEncodedUtils.parse((String)vegaURI.getQuery(), (Charset)Consts.UTF_8));
            }
        }
        return this.pathStateManager.getStateForPath(iWebPath2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IWebHost getWebHost(HttpHost httpHost) {
        IWebHost iWebHost = null;
        IWorkspace iWorkspace = this.workspace;
        synchronized (iWorkspace) {
            IWebModel iWebModel = this.workspace.getWebModel();
            iWebHost = iWebModel.getWebHostByHttpHost(httpHost);
            if (iWebHost == null) {
                iWebHost = iWebModel.createWebHostFromHttpHost(httpHost);
            }
        }
        this.processWebHost(iWebHost);
        return iWebHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWebHost(IWebHost iWebHost) {
        IWebPath iWebPath = iWebHost.getRootPath();
        PathStateManager pathStateManager = this.pathStateManager;
        synchronized (pathStateManager) {
            if (!this.pathStateManager.hasSeenPath(iWebPath)) {
                this.pathStateManager.createStateForPath(iWebPath, this.unknownProcessor);
            }
        }
    }

    private void processPath(IWebPath iWebPath, VegaURI vegaURI, boolean bl, boolean bl2) {
        if (!bl || bl && bl2) {
            this.processDirectory(iWebPath, vegaURI);
        } else if (vegaURI.getQuery() != null) {
            iWebPath.setPathType(IWebPath.PathType.PATH_FILE);
            this.processPathWithQuery(iWebPath, vegaURI);
        } else {
            this.processUnknown(iWebPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDirectory(IWebPath iWebPath, VegaURI vegaURI) {
        PathStateManager pathStateManager = this.pathStateManager;
        synchronized (pathStateManager) {
            if (!this.pathStateManager.hasSeenPath(iWebPath)) {
                iWebPath.setPathType(IWebPath.PathType.PATH_DIRECTORY);
                PathState pathState = this.pathStateManager.createStateForPath(iWebPath, this.directoryProcessor);
                if (vegaURI.getQuery() != null) {
                    pathState.maybeAddParameters(URLEncodedUtils.parse((String)vegaURI.getQuery(), (Charset)Consts.UTF_8));
                }
                return;
            }
            if (iWebPath.getPathType() != IWebPath.PathType.PATH_DIRECTORY) {
                System.out.println("Scan state node for path=" + iWebPath + " already exists but it's not a directory in UriParser.processDirectory()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPathWithQuery(IWebPath iWebPath, VegaURI vegaURI) {
        iWebPath.setPathType(IWebPath.PathType.PATH_FILE);
        List list = URLEncodedUtils.parse((String)vegaURI.getQuery(), (Charset)Consts.UTF_8);
        PathStateManager pathStateManager = this.pathStateManager;
        synchronized (pathStateManager) {
            PathState pathState = this.getPathStateForFile(iWebPath);
            if (pathState != null) {
                pathState.maybeAddParameters(list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PathState getPathStateForFile(IWebPath iWebPath) {
        PathStateManager pathStateManager = this.pathStateManager;
        synchronized (pathStateManager) {
            if (this.pathStateManager.hasSeenPath(iWebPath)) {
                return this.pathStateManager.getStateForPath(iWebPath);
            }
            return this.pathStateManager.createStateForPath(iWebPath, this.fileProcessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUnknown(IWebPath iWebPath) {
        PathStateManager pathStateManager = this.pathStateManager;
        synchronized (pathStateManager) {
            if (this.pathStateManager.hasSeenPath(iWebPath)) {
                return;
            }
            this.pathStateManager.createStateForPath(iWebPath, this.unknownProcessor);
        }
    }
}

