/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.state;

import com.subgraph.vega.api.crawler.ICrawlerResponseProcessor;
import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.api.model.web.IWebPathParameters;
import com.subgraph.vega.impl.scanner.handlers.FileProcessor;
import com.subgraph.vega.impl.scanner.state.PathState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.NameValuePair;

public class PathStateParameterManager {
    private static final ICrawlerResponseProcessor fileFetchProcessor = new FileProcessor();
    private final PathState pathState;
    private final Map<Set<String>, List<PathState>> parametersToPathStates = new HashMap<Set<String>, List<PathState>>();
    private final Map<Set<String>, List<PathState>> parametersToPostPathStates = new HashMap<Set<String>, List<PathState>>();

    PathStateParameterManager(PathState pathState) {
        this.pathState = pathState;
        IWebPath iWebPath = pathState.getPath();
        IWebPathParameters iWebPathParameters = iWebPath.getGetParameters();
        for (List list : iWebPathParameters.getParameterLists()) {
            this.addParameterList(list);
        }
    }

    public synchronized List<PathState> addParameterList(List<NameValuePair> list) {
        Set<String> set = this.getNameSetForParameterList(list);
        if (this.parametersToPathStates.containsKey(set)) {
            return this.parametersToPathStates.get(set);
        }
        ArrayList<PathState> arrayList = new ArrayList<PathState>(list.size());
        this.parametersToPathStates.put(set, arrayList);
        int n = 0;
        while (n < list.size()) {
            if (!this.isExcludedParameter(list.get(n))) {
                this.addFuzzablePathState(arrayList, list, n);
            }
            ++n;
        }
        return arrayList;
    }

    private boolean isExcludedParameter(NameValuePair nameValuePair) {
        return this.pathState.getPathStateManager().isExcludedParameter(nameValuePair.getName());
    }

    private void addFuzzablePathState(List<PathState> list, List<NameValuePair> list2, int n) {
        PathState pathState = PathState.createParameterPathState(fileFetchProcessor, this.pathState, list2, n);
        list.add(pathState);
    }

    private Set<String> getNameSetForParameterList(List<NameValuePair> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (NameValuePair nameValuePair : list) {
            hashSet.add(nameValuePair.getName());
        }
        return hashSet;
    }

    public synchronized boolean hasParameterList(List<NameValuePair> list) {
        return this.parametersToPathStates.containsKey(this.getNameSetForParameterList(list));
    }

    public synchronized List<PathState> getStatesForParameterList(List<NameValuePair> list) {
        List<PathState> list2 = this.parametersToPathStates.get(this.getNameSetForParameterList(list));
        if (list2 == null) {
            return Collections.emptyList();
        }
        return list2;
    }

    public synchronized boolean hasPostParameterList(List<NameValuePair> list) {
        return this.parametersToPostPathStates.containsKey(this.getNameSetForParameterList(list));
    }

    public synchronized List<PathState> getStatesForPostParameterList(List<NameValuePair> list) {
        List<PathState> list2 = this.parametersToPostPathStates.get(this.getNameSetForParameterList(list));
        if (list2 == null) {
            return Collections.emptyList();
        }
        return list2;
    }

    public synchronized List<PathState> addPostParameterList(List<NameValuePair> list) {
        Set<String> set = this.getNameSetForParameterList(list);
        if (this.parametersToPostPathStates.containsKey(set)) {
            return this.parametersToPostPathStates.get(set);
        }
        ArrayList<PathState> arrayList = new ArrayList<PathState>();
        this.parametersToPostPathStates.put(set, arrayList);
        int n = 0;
        while (n < list.size()) {
            if (!this.isExcludedParameter(list.get(n))) {
                this.addFuzzablePostPathState(arrayList, list, n);
            }
            ++n;
        }
        return arrayList;
    }

    private void addFuzzablePostPathState(List<PathState> list, List<NameValuePair> list2, int n) {
        PathState pathState = PathState.createPostParameterPathState(fileFetchProcessor, this.pathState, list2, n);
        list.add(pathState);
    }
}

