/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.state;

import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.http.requests.IPageFingerprint;
import org.apache.http.client.methods.HttpUriRequest;

public class ModuleContextState {
    private static final int INITIAL_CAPACITY = 8;
    private HttpUriRequest[] savedRequests;
    private IHttpResponse[] savedResponses;
    private int currentCapacity;
    private int responseCount;
    private int sentRequestCount;
    private boolean moduleFailed;

    public synchronized void incrementSentRequestCount() {
        ++this.sentRequestCount;
    }

    public synchronized int incrementResponseCount() {
        ++this.responseCount;
        return this.responseCount;
    }

    public synchronized boolean allResponsesReceieved() {
        return this.responseCount == this.sentRequestCount;
    }

    private void ensureCapacity(int n) {
        if (this.currentCapacity == 0) {
            this.currentCapacity = 8;
            this.savedRequests = new HttpUriRequest[8];
            this.savedResponses = new IHttpResponse[8];
        }
        if (n >= this.currentCapacity) {
            HttpUriRequest[] httpUriRequestArray = new HttpUriRequest[n + 1];
            IHttpResponse[] iHttpResponseArray = new IHttpResponse[n + 1];
            System.arraycopy(this.savedRequests, 0, httpUriRequestArray, 0, this.currentCapacity);
            System.arraycopy(this.savedResponses, 0, iHttpResponseArray, 0, this.currentCapacity);
            this.savedRequests = httpUriRequestArray;
            this.savedResponses = iHttpResponseArray;
            this.currentCapacity = n + 1;
        }
    }

    public synchronized void addRequestResponse(int n, HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse) {
        this.ensureCapacity(n);
        this.savedRequests[n] = httpUriRequest;
        this.savedResponses[n] = iHttpResponse;
    }

    public synchronized HttpUriRequest getSavedRequest(int n) {
        this.ensureCapacity(n);
        return this.savedRequests[n];
    }

    public synchronized IHttpResponse getSavedResponse(int n) {
        this.ensureCapacity(n);
        return this.savedResponses[n];
    }

    public synchronized String getSavedResponseBody(int n) {
        this.ensureCapacity(n);
        IHttpResponse iHttpResponse = this.savedResponses[n];
        if (iHttpResponse != null) {
            return iHttpResponse.getBodyAsString();
        }
        return null;
    }

    public synchronized IPageFingerprint getSavedFingerprint(int n) {
        this.ensureCapacity(n);
        IHttpResponse iHttpResponse = this.savedResponses[n];
        if (iHttpResponse != null) {
            return iHttpResponse.getPageFingerprint();
        }
        return null;
    }

    public synchronized void setModuleFailed() {
        this.moduleFailed = true;
    }

    public synchronized boolean hasModuleFailed() {
        return this.moduleFailed;
    }
}

