/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.state;

import com.google.common.net.InternetDomainName;
import com.subgraph.vega.api.crawler.ICrawlerResponseProcessor;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.http.requests.IPageFingerprint;
import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.api.model.requests.IRequestLog;
import com.subgraph.vega.api.scanner.IInjectionModuleContext;
import com.subgraph.vega.api.scanner.IPathState;
import com.subgraph.vega.impl.scanner.requests.IRequestBuilder;
import com.subgraph.vega.impl.scanner.state.CrawlerCallbackWrapper;
import com.subgraph.vega.impl.scanner.state.ModuleContextState;
import com.subgraph.vega.impl.scanner.state.PathState;
import com.subgraph.vega.impl.scanner.state.PathStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;

public class ModuleContext
implements IInjectionModuleContext {
    private static final Logger logger = Logger.getLogger("scanner");
    private final PathStateManager scanState;
    private final IRequestBuilder requestBuilder;
    private final PathState pathState;
    private final int currentIndex;
    private final ModuleContextState contextState;
    private final List<String> stringHighlights;
    private final List<String> regexHighlights;
    private final List<String> caseInsensitiveRegexHighlights;

    ModuleContext(PathStateManager pathStateManager, IRequestBuilder iRequestBuilder, PathState pathState, int n) {
        this.scanState = pathStateManager;
        this.requestBuilder = iRequestBuilder;
        this.pathState = pathState;
        this.currentIndex = n;
        this.contextState = new ModuleContextState();
        this.stringHighlights = new ArrayList<String>();
        this.regexHighlights = new ArrayList<String>();
        this.caseInsensitiveRegexHighlights = new ArrayList<String>();
    }

    ModuleContext(PathStateManager pathStateManager, IRequestBuilder iRequestBuilder, PathState pathState) {
        this(pathStateManager, iRequestBuilder, pathState, -1);
    }

    private ModuleContext(ModuleContext moduleContext, int n) {
        this.scanState = moduleContext.scanState;
        this.requestBuilder = moduleContext.requestBuilder;
        this.pathState = moduleContext.pathState;
        this.contextState = moduleContext.contextState;
        this.currentIndex = n;
        this.stringHighlights = new ArrayList<String>(moduleContext.stringHighlights);
        this.regexHighlights = new ArrayList<String>(moduleContext.regexHighlights);
        this.caseInsensitiveRegexHighlights = new ArrayList<String>();
    }

    public IPathState getPathState() {
        return this.pathState;
    }

    public int incrementResponseCount() {
        return this.contextState.incrementResponseCount();
    }

    public boolean allResponsesReceived() {
        return this.contextState.allResponsesReceieved();
    }

    public void addRequestResponse(HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse) {
        if (this.currentIndex == -1) {
            throw new IllegalStateException("Cannot add request/response because index has not been specified");
        }
        this.contextState.addRequestResponse(this.currentIndex, httpUriRequest, iHttpResponse);
    }

    public void addRequestResponse(int n, HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse) {
        this.contextState.addRequestResponse(n, httpUriRequest, iHttpResponse);
    }

    public HttpUriRequest getSavedRequest(int n) {
        return this.contextState.getSavedRequest(n);
    }

    public IHttpResponse getSavedResponse(int n) {
        return this.contextState.getSavedResponse(n);
    }

    public String getSavedResponseBody(int n) {
        return this.contextState.getSavedResponseBody(n);
    }

    public IPageFingerprint getSavedFingerprint(int n) {
        return this.contextState.getSavedFingerprint(n);
    }

    public boolean isFingerprintMatch(int n, int n2) {
        IPageFingerprint iPageFingerprint = this.getSavedFingerprint(n);
        IPageFingerprint iPageFingerprint2 = this.getSavedFingerprint(n2);
        if (iPageFingerprint == null || iPageFingerprint2 == null) {
            return false;
        }
        return iPageFingerprint.isSame(iPageFingerprint2);
    }

    public boolean isFingerprintMatch(int n, IPageFingerprint iPageFingerprint) {
        IPageFingerprint iPageFingerprint2 = this.getSavedFingerprint(n);
        if (iPageFingerprint == null || iPageFingerprint2 == null) {
            return false;
        }
        return iPageFingerprint.isSame(iPageFingerprint2);
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void submitRequest(HttpUriRequest httpUriRequest, ICrawlerResponseProcessor iCrawlerResponseProcessor, int n) {
        this.contextState.incrementSentRequestCount();
        this.pathState.incrementOutstandingRequests();
        this.scanState.getCrawler().submitTask(httpUriRequest, this.getWrappedCallback(iCrawlerResponseProcessor), (Object)new ModuleContext(this, n));
    }

    private ICrawlerResponseProcessor getWrappedCallback(ICrawlerResponseProcessor iCrawlerResponseProcessor) {
        if (this.scanState.requestLoggingEnabled()) {
            return CrawlerCallbackWrapper.createLogging(this.pathState, this.scanState.getRequestLog(), iCrawlerResponseProcessor);
        }
        return CrawlerCallbackWrapper.create(this.pathState, iCrawlerResponseProcessor);
    }

    public void submitRequest(HttpUriRequest httpUriRequest, ICrawlerResponseProcessor iCrawlerResponseProcessor) {
        this.submitRequest(httpUriRequest, iCrawlerResponseProcessor, 0);
    }

    public void submitRequest(ICrawlerResponseProcessor iCrawlerResponseProcessor, int n) {
        HttpUriRequest httpUriRequest = this.requestBuilder.createBasicRequest();
        if (httpUriRequest != null) {
            this.submitRequest(httpUriRequest, iCrawlerResponseProcessor, n);
        }
    }

    public void submitAlteredRequest(ICrawlerResponseProcessor iCrawlerResponseProcessor, String string) {
        this.submitAlteredRequest(iCrawlerResponseProcessor, string, false, 0);
    }

    public void submitAlteredRequest(ICrawlerResponseProcessor iCrawlerResponseProcessor, String string, int n) {
        this.submitAlteredRequest(iCrawlerResponseProcessor, string, false, n);
    }

    public void submitAlteredRequest(ICrawlerResponseProcessor iCrawlerResponseProcessor, String string, boolean bl, int n) {
        HttpUriRequest httpUriRequest = this.requestBuilder.createAlteredRequest(string, bl);
        if (httpUriRequest != null) {
            this.submitRequest(httpUriRequest, iCrawlerResponseProcessor, n);
        }
    }

    public void submitAlteredParameterNameRequest(ICrawlerResponseProcessor iCrawlerResponseProcessor, String string, int n) {
        HttpUriRequest httpUriRequest = this.requestBuilder.createAlteredParameterNameRequest(string);
        if (httpUriRequest != null) {
            this.submitRequest(httpUriRequest, iCrawlerResponseProcessor, n);
        }
    }

    public void submitMultipleAlteredRequests(ICrawlerResponseProcessor iCrawlerResponseProcessor, String[] stringArray) {
        this.submitMultipleAlteredRequests(iCrawlerResponseProcessor, stringArray, false);
    }

    public void submitMultipleAlteredRequests(ICrawlerResponseProcessor iCrawlerResponseProcessor, String[] stringArray, boolean bl) {
        int n = 0;
        while (n < stringArray.length) {
            this.submitAlteredRequest(iCrawlerResponseProcessor, stringArray[n], bl, n);
            ++n;
        }
    }

    public void setModuleFailed() {
        this.contextState.setModuleFailed();
    }

    public boolean hasModuleFailed() {
        return this.contextState.hasModuleFailed();
    }

    public void reportRequestException(HttpUriRequest httpUriRequest, Throwable throwable) {
        this.pathState.decrementOutstandingRequests();
        this.scanState.reportRequestException(httpUriRequest, throwable);
    }

    public void error(HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse, String string) {
        long l = this.scanState.getRequestLog().addRequestResponse(iHttpResponse);
        logger.warning("Error running module: " + string + " (request logged with id=" + l + ")");
    }

    public void debug(String string) {
        this.scanState.debug("[" + this.pathState.getPath().getUri() + "] " + string);
    }

    public void debug(String string, Boolean bl) {
        this.scanState.debug("[" + this.pathState.getPath().getUri() + "] " + string, bl);
    }

    public void analyzePage(HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse) {
        this.scanState.analyzePage(this, httpUriRequest, iHttpResponse);
    }

    public void responseChecks(HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse) {
        this.scanState.analyzeContent(this, httpUriRequest, iHttpResponse);
        this.scanState.analyzePage(this, httpUriRequest, iHttpResponse);
    }

    public void contentChecks(HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse) {
        this.scanState.analyzeContent(this, httpUriRequest, iHttpResponse);
    }

    public void responseChecks(int n) {
        HttpUriRequest httpUriRequest = this.getSavedRequest(n);
        IHttpResponse iHttpResponse = this.getSavedResponse(n);
        if (httpUriRequest != null && iHttpResponse != null) {
            this.responseChecks(httpUriRequest, iHttpResponse);
        }
    }

    public void pivotChecks(HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse) {
        this.scanState.analyzePivot(this, httpUriRequest, iHttpResponse);
        this.scanState.analyzeContent(this, httpUriRequest, iHttpResponse);
        this.scanState.analyzePage(this, httpUriRequest, iHttpResponse);
    }

    public void publishAlert(String string, String string2, HttpRequest httpRequest, IHttpResponse iHttpResponse, Object ... objectArray) {
        this.publishAlert(string, null, string2, httpRequest, iHttpResponse, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishAlert(String string, String string2, String string3, HttpRequest httpRequest, IHttpResponse iHttpResponse, Object ... objectArray) {
        this.debug("Publishing Alert: (" + string + ") [" + httpRequest.getRequestLine().getUri() + "] ");
        IScanInstance iScanInstance = this.scanState.getScanInstance();
        IRequestLog iRequestLog = this.scanState.getRequestLog();
        IScanInstance iScanInstance2 = iScanInstance;
        synchronized (iScanInstance2) {
            if (string2 != null && iScanInstance.hasAlertKey(string2)) {
                return;
            }
            long l = iRequestLog.addRequestResponse(iHttpResponse);
            IScanAlert iScanAlert = iScanInstance.createAlert(string, string2, l);
            int n = 0;
            while (n + 1 < objectArray.length) {
                if (objectArray[n] instanceof String) {
                    iScanAlert.setProperty((String)objectArray[n], objectArray[n + 1]);
                } else {
                    logger.warning("Property key passed to publishAlert() is not a string");
                }
                n += 2;
            }
            if (this.pathState.isParametric() && this.pathState.getFuzzableParameter() != null) {
                iScanAlert.setProperty("param", (Object)this.pathState.getFuzzableParameter().getName());
            }
            iScanAlert.setProperty("methods", (Object)httpRequest.getRequestLine().getMethod());
            if (string3 != null) {
                iScanAlert.setStringProperty("message", string3);
            }
            for (String string4 : this.stringHighlights) {
                iScanAlert.addStringMatchHighlight(string4);
            }
            for (String string5 : this.regexHighlights) {
                iScanAlert.addRegexHighlight(string5);
            }
            for (String string6 : this.caseInsensitiveRegexHighlights) {
                iScanAlert.addRegexCaseInsensitiveHighlight(string6);
            }
            iScanInstance.addAlert(iScanAlert);
        }
    }

    public List<String> getFileExtensionList() {
        return this.scanState.getFileExtensionList();
    }

    public void setProperty(String string, Object object) {
        this.scanState.getScanInstance().setProperty(string, object);
    }

    public void setStringProperty(String string, String string2) {
        this.scanState.getScanInstance().setStringProperty(string, string2);
    }

    public void setIntegerProperty(String string, int n) {
        this.scanState.getScanInstance().setIntegerProperty(string, n);
    }

    public Object getProperty(String string) {
        return this.scanState.getScanInstance().getProperty(string);
    }

    public String getStringProperty(String string) {
        return this.scanState.getScanInstance().getStringProperty(string);
    }

    public Integer getIntegerProperty(String string) {
        return this.scanState.getScanInstance().getIntegerProperty(string);
    }

    public List<String> propertyKeys() {
        return this.scanState.getScanInstance().propertyKeys();
    }

    public void addStringHighlight(String string) {
        this.stringHighlights.add(string);
    }

    public void addRegexHighlight(String string) {
        try {
            Pattern.compile(string);
            this.regexHighlights.add(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            logger.warning("Invalid regular expression '" + string + "' passed to addHighlightRegex(): " + patternSyntaxException.getDescription());
        }
    }

    public void addRegexCaseInsensitiveHighlight(String string) {
        try {
            Pattern.compile(string);
            this.caseInsensitiveRegexHighlights.add(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            logger.warning("Invalid regular expression '" + string + "' passed to addHighlightRegex(): " + patternSyntaxException.getDescription());
        }
    }

    public void reset() {
        this.stringHighlights.clear();
        this.regexHighlights.clear();
    }

    public boolean alertExists(String string) {
        IScanInstance iScanInstance = this.scanState.getScanInstance();
        return iScanInstance.hasAlertKey(string);
    }

    public InternetDomainName internetDomainName(String string) {
        return InternetDomainName.from((String)string);
    }

    public boolean isValidInternetDomainName(String string) {
        return InternetDomainName.isValid((String)string);
    }
}

