/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.state;

import com.subgraph.vega.api.crawler.ICrawlerResponseProcessor;
import com.subgraph.vega.api.crawler.IWebCrawler;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.model.requests.IRequestLog;
import com.subgraph.vega.impl.scanner.state.PathState;
import org.apache.http.client.methods.HttpUriRequest;

public class CrawlerCallbackWrapper
implements ICrawlerResponseProcessor {
    private final PathState pathState;
    private final boolean logRequest;
    private final IRequestLog requestLog;
    private final ICrawlerResponseProcessor wrappedCallback;

    static ICrawlerResponseProcessor createLogging(PathState pathState, IRequestLog iRequestLog, ICrawlerResponseProcessor iCrawlerResponseProcessor) {
        return new CrawlerCallbackWrapper(pathState, iRequestLog, iCrawlerResponseProcessor);
    }

    static ICrawlerResponseProcessor create(PathState pathState, ICrawlerResponseProcessor iCrawlerResponseProcessor) {
        return new CrawlerCallbackWrapper(pathState, null, iCrawlerResponseProcessor);
    }

    private CrawlerCallbackWrapper(PathState pathState, IRequestLog iRequestLog, ICrawlerResponseProcessor iCrawlerResponseProcessor) {
        this.pathState = pathState;
        this.logRequest = iRequestLog != null;
        this.requestLog = iRequestLog;
        this.wrappedCallback = iCrawlerResponseProcessor;
    }

    public void processResponse(IWebCrawler iWebCrawler, HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse, Object object) {
        this.pathState.decrementOutstandingRequests();
        if (!iHttpResponse.lockResponseEntity()) {
            return;
        }
        this.wrappedCallback.processResponse(iWebCrawler, httpUriRequest, iHttpResponse, object);
        if (this.logRequest) {
            this.requestLog.addRequestResponse(iHttpResponse);
        }
    }

    public void processException(HttpUriRequest httpUriRequest, Throwable throwable, Object object) {
        this.pathState.decrementOutstandingRequests();
        this.pathState.getPathStateManager().reportRequestException(httpUriRequest, throwable);
    }
}

