/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.requests;

import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.impl.scanner.requests.AbstractRequestBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public abstract class AbstractParameterRequestBuilder
extends AbstractRequestBuilder {
    protected final List<NameValuePair> parameters;
    protected final int parameterFuzzIndex;

    protected AbstractParameterRequestBuilder(IHttpRequestEngine iHttpRequestEngine, IWebPath iWebPath, List<NameValuePair> list, int n) {
        super(iHttpRequestEngine, iWebPath);
        if (list == null || n < 0 || n >= list.size()) {
            throw new IllegalArgumentException();
        }
        this.parameters = list;
        this.parameterFuzzIndex = n;
    }

    @Override
    public boolean isFuzzable() {
        return true;
    }

    @Override
    public NameValuePair getFuzzableParameter() {
        return this.parameters.get(this.parameterFuzzIndex);
    }

    protected List<NameValuePair> getAlteredParameters(String string, boolean bl, boolean bl2) {
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        int n = 0;
        while (n < this.parameters.size()) {
            NameValuePair nameValuePair = this.parameters.get(n);
            if (this.parameterFuzzIndex == n) {
                arrayList.add(this.fuzzParameter(nameValuePair, string, bl, bl2));
            } else {
                arrayList.add(nameValuePair);
            }
            ++n;
        }
        return arrayList;
    }

    protected NameValuePair fuzzParameter(NameValuePair nameValuePair, String string, boolean bl, boolean bl2) {
        if (bl2) {
            return new BasicNameValuePair(string, nameValuePair.getValue());
        }
        if (bl) {
            return new BasicNameValuePair(nameValuePair.getName(), String.valueOf(nameValuePair.getValue()) + string);
        }
        return new BasicNameValuePair(nameValuePair.getName(), string);
    }
}

