/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.handlers;

import com.subgraph.vega.api.crawler.ICrawlerResponseProcessor;
import com.subgraph.vega.api.crawler.IWebCrawler;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.http.requests.IPageFingerprint;
import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.api.scanner.IInjectionModuleContext;
import com.subgraph.vega.api.scanner.IPathState;
import com.subgraph.vega.impl.scanner.handlers.DirectoryProcessor;
import com.subgraph.vega.impl.scanner.handlers.FileProcessor;
import com.subgraph.vega.impl.scanner.handlers.ParametricCheckHandler;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;

public class UnknownProcessor
implements ICrawlerResponseProcessor {
    private final ParametricCheckHandler parametricChecks = new ParametricCheckHandler();
    private final ICrawlerResponseProcessor fetchFileProcessor = new FileProcessor();
    private final ICrawlerResponseProcessor fetchDirProcessor = new DirectoryProcessor();

    public void processResponse(IWebCrawler iWebCrawler, HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse, Object object) {
        IInjectionModuleContext iInjectionModuleContext = (IInjectionModuleContext)object;
        IPathState iPathState = iInjectionModuleContext.getPathState();
        if (iInjectionModuleContext.getCurrentIndex() == 0) {
            this.processInitialResponse(httpUriRequest, iHttpResponse, iInjectionModuleContext, iPathState);
        } else {
            this.processProbeResponses(httpUriRequest, iHttpResponse, iInjectionModuleContext, iPathState);
        }
    }

    private void processInitialResponse(HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse, IInjectionModuleContext iInjectionModuleContext, IPathState iPathState) {
        iPathState.setResponse(iHttpResponse);
        if (iHttpResponse.isFetchFail()) {
            iInjectionModuleContext.error(httpUriRequest, iHttpResponse, "during initial resource fetch");
            return;
        }
        iPathState.getPath().setVisited(true);
        IPageFingerprint iPageFingerprint = iHttpResponse.getPageFingerprint();
        IPathState iPathState2 = iPathState.get404Parent();
        int n = iHttpResponse.getResponseCode();
        if (iPathState2 == null && n == 404 || iPathState.hasParent404Fingerprint(iPageFingerprint)) {
            iPathState.setPageMissing();
            iPathState.unlockChildren();
            iInjectionModuleContext.debug("Starting parametric checks on unknown path because page is missing.");
            this.parametricChecks.initialize(iPathState);
            return;
        }
        if (iPathState2 != null && !iHttpResponse.getBodyAsString().isEmpty() && n == 200 && iPageFingerprint.isSame(iPathState2.getUnknownFingerprint())) {
            iInjectionModuleContext.debug("Unknown path fetch matches parent unknown fp, processing as a file.");
            iPathState.getPath().setPathType(IWebPath.PathType.PATH_FILE);
            this.fetchFileProcessor.processResponse(null, httpUriRequest, iHttpResponse, (Object)iInjectionModuleContext);
            return;
        }
        if (iPathState2 != null && n >= 300 && n < 400 && iPageFingerprint.isSame(iPathState2.getUnknownFingerprint()) && iPageFingerprint.isSame(iPathState2.getPathFingerprint())) {
            iInjectionModuleContext.debug("Unknown path fetch matches both parent probes, processing as file.");
            iPathState.getPath().setPathType(IWebPath.PathType.PATH_FILE);
            this.fetchFileProcessor.processResponse(null, httpUriRequest, iHttpResponse, (Object)iInjectionModuleContext);
            return;
        }
        iInjectionModuleContext.debug("Sending probes to resolve unknown path.");
        this.sendProbeRequests(iPathState);
    }

    private void sendProbeRequests(IPathState iPathState) {
        IInjectionModuleContext iInjectionModuleContext = iPathState.createModuleContext();
        iInjectionModuleContext.submitAlteredRequest((ICrawlerResponseProcessor)this, "/", 1);
        iInjectionModuleContext.submitAlteredRequest((ICrawlerResponseProcessor)this, "/abc123/", 2);
    }

    private void processProbeResponses(HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse, IInjectionModuleContext iInjectionModuleContext, IPathState iPathState) {
        if (iHttpResponse.isFetchFail()) {
            iInjectionModuleContext.error(httpUriRequest, iHttpResponse, "Fetch failed processing unknown path probe responses");
            this.callFetchHandler(iInjectionModuleContext, iPathState);
        }
        iInjectionModuleContext.addRequestResponse(httpUriRequest, iHttpResponse);
        iInjectionModuleContext.incrementResponseCount();
        if (iInjectionModuleContext.allResponsesReceived()) {
            this.analyzeResponses(iInjectionModuleContext, iPathState);
        }
    }

    private void analyzeResponses(IInjectionModuleContext iInjectionModuleContext, IPathState iPathState) {
        if (iInjectionModuleContext.isFingerprintMatch(1, 2) && iInjectionModuleContext.isFingerprintMatch(2, iPathState.getPathFingerprint())) {
            iInjectionModuleContext.debug("Probes all match for unknown path, processing as file.");
            iPathState.getPath().setPathType(IWebPath.PathType.PATH_FILE);
            this.callFetchHandler(iInjectionModuleContext, iPathState);
            return;
        }
        IHttpResponse iHttpResponse = iInjectionModuleContext.getSavedResponse(1);
        if (iInjectionModuleContext.isFingerprintMatch(1, iPathState.getPathFingerprint())) {
            iInjectionModuleContext.debug("Trailing / probe matches initial path fetch, processing as directory.");
            this.assumeDirectory(iHttpResponse, iInjectionModuleContext, iPathState);
            return;
        }
        int n = iPathState.getResponse().getResponseCode();
        int n2 = iHttpResponse.getResponseCode();
        if (n >= 300 && n < 400 && this.hasLocationHeaderWithRequestUri(iPathState, iInjectionModuleContext.getSavedRequest(1))) {
            iInjectionModuleContext.debug("Trailing slash probe matches redirect from initial fetch, processing as directory");
            iPathState.setSureDirectory();
            this.assumeDirectory(iHttpResponse, iInjectionModuleContext, iPathState);
            return;
        }
        if (this.isProbe404(iPathState, iHttpResponse)) {
            iInjectionModuleContext.debug("Trailing slash probe looks like a 404, processing as a file");
            iPathState.getPath().setPathType(IWebPath.PathType.PATH_FILE);
        } else if (n < 300 && n2 >= 300 && iPathState.getResponse().getBodyAsString().length() > 0) {
            iInjectionModuleContext.debug("Trailing slash probe returned code 3xx - 5xx and initial fetch was a 200, processing as file");
            iPathState.getPath().setPathType(IWebPath.PathType.PATH_FILE);
        } else {
            iInjectionModuleContext.debug("No idea what this is, try processing as file");
        }
        this.callFetchHandler(iInjectionModuleContext, iPathState);
    }

    private boolean isProbe404(IPathState iPathState, IHttpResponse iHttpResponse) {
        IPathState iPathState2 = iPathState.get404Parent();
        int n = iHttpResponse.getResponseCode();
        IPageFingerprint iPageFingerprint = iHttpResponse.getPageFingerprint();
        if (iPathState2 != null) {
            return iPathState2.has404FingerprintMatching(iPageFingerprint);
        }
        return n == 404;
    }

    private boolean hasLocationHeaderWithRequestUri(IPathState iPathState, HttpUriRequest httpUriRequest) {
        String string = this.getLocationHeader(iPathState);
        if (string == null) {
            return false;
        }
        String string2 = httpUriRequest.getURI().toString();
        return string.equalsIgnoreCase(string2);
    }

    private String getLocationHeader(IPathState iPathState) {
        HttpResponse httpResponse = iPathState.getResponse().getRawResponse();
        Header header = httpResponse.getFirstHeader("Location");
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    private void assumeDirectory(IHttpResponse iHttpResponse, IInjectionModuleContext iInjectionModuleContext, IPathState iPathState) {
        iPathState.getPath().setPathType(IWebPath.PathType.PATH_DIRECTORY);
        iPathState.setUnknownFingerprint(iPathState.getPathFingerprint());
        iPathState.setResponse(iHttpResponse);
        this.callFetchHandler(iInjectionModuleContext, iPathState);
    }

    private void callFetchHandler(IInjectionModuleContext iInjectionModuleContext, IPathState iPathState) {
        IWebPath iWebPath = iPathState.getPath();
        HttpUriRequest httpUriRequest = iPathState.createRequest();
        IHttpResponse iHttpResponse = iPathState.getResponse();
        if (iWebPath.getPathType() == IWebPath.PathType.PATH_DIRECTORY || iWebPath.getParentPath() == null) {
            this.fetchDirProcessor.processResponse(null, httpUriRequest, iHttpResponse, (Object)iInjectionModuleContext);
        } else {
            this.fetchFileProcessor.processResponse(null, httpUriRequest, iHttpResponse, (Object)iInjectionModuleContext);
        }
    }

    public void processException(HttpUriRequest httpUriRequest, Throwable throwable, Object object) {
        IInjectionModuleContext iInjectionModuleContext = (IInjectionModuleContext)object;
        iInjectionModuleContext.reportRequestException(httpUriRequest, throwable);
    }
}

