/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.handlers;

import com.subgraph.vega.api.crawler.ICrawlerResponseProcessor;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.http.requests.IPageFingerprint;
import com.subgraph.vega.api.scanner.IInjectionModuleContext;
import com.subgraph.vega.api.scanner.IPathState;
import com.subgraph.vega.impl.scanner.handlers.CrawlerModule;
import com.subgraph.vega.impl.scanner.handlers.InjectionChecks;
import com.subgraph.vega.impl.scanner.handlers.OgnlHandler;
import java.util.Random;
import org.apache.http.client.methods.HttpUriRequest;

public class ParametricCheckHandler
extends CrawlerModule {
    private static final Random random = new Random();
    private final ICrawlerResponseProcessor ognlHandler = new OgnlHandler();
    private final InjectionChecks injectionChecks = new InjectionChecks();

    @Override
    public void initialize(IPathState iPathState) {
        IInjectionModuleContext iInjectionModuleContext = iPathState.createModuleContext();
        if (!iPathState.isParametric()) {
            iInjectionModuleContext.debug("not parametric??");
            iPathState.setDone();
            return;
        }
        String string = this.generateBogusParameter();
        int n = 0;
        while (n < 5) {
            iInjectionModuleContext.submitAlteredRequest((ICrawlerResponseProcessor)this, string, n);
            ++n;
        }
    }

    private String generateBogusParameter() {
        int n = random.nextInt(9000) + 1000;
        return "asdf" + n;
    }

    @Override
    public void runModule(HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse, IInjectionModuleContext iInjectionModuleContext) {
        if (iHttpResponse.isFetchFail()) {
            iInjectionModuleContext.error(httpUriRequest, iHttpResponse, "during parameter behavior test");
            this.maybeScheduleNext(iInjectionModuleContext);
            return;
        }
        IPageFingerprint iPageFingerprint = iInjectionModuleContext.getPathState().getPathFingerprint();
        if (iPageFingerprint != null && iPageFingerprint.isSame(iHttpResponse.getPageFingerprint())) {
            iInjectionModuleContext.getPathState().setBogusParameter();
            this.maybeScheduleNext(iInjectionModuleContext);
            return;
        }
        if (iInjectionModuleContext.getPathState().isBogusParameter()) {
            iInjectionModuleContext.debug("We classified parameter as no effect, but now it's changing");
            iInjectionModuleContext.getPathState().setResponseVaries();
            this.maybeScheduleNext(iInjectionModuleContext);
            return;
        }
        if (!iInjectionModuleContext.getPathState().has404Fingerprints()) {
            iInjectionModuleContext.debug("Adding 404 signature from parameter probe");
            iInjectionModuleContext.getPathState().add404Fingerprint(iHttpResponse.getPageFingerprint());
        } else if (!iInjectionModuleContext.getPathState().has404FingerprintMatching(iHttpResponse.getPageFingerprint())) {
            iInjectionModuleContext.debug("Signature does not match previous responses");
            iInjectionModuleContext.getPathState().setResponseVaries();
        }
        this.maybeScheduleNext(iInjectionModuleContext);
    }

    private void maybeScheduleNext(IInjectionModuleContext iInjectionModuleContext) {
        if (iInjectionModuleContext.incrementResponseCount() < 5) {
            return;
        }
        this.scheduleNext(iInjectionModuleContext.getPathState());
    }

    private void scheduleNext(IPathState iPathState) {
        IInjectionModuleContext iInjectionModuleContext = iPathState.createModuleContext();
        String string = iPathState.getFuzzableParameter().getName();
        if (!iPathState.isBogusParameter() && !iPathState.getResponseVaries() && string != null) {
            iInjectionModuleContext.submitAlteredParameterNameRequest(this.ognlHandler, "[0]['" + string + "']", 0);
            iInjectionModuleContext.submitAlteredParameterNameRequest(this.ognlHandler, "[0]['vega']", 1);
        }
        this.injectionChecks.initialize(iPathState);
    }
}

