/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.handlers;

import com.subgraph.vega.api.crawler.ICrawlerResponseProcessor;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.http.requests.IPageFingerprint;
import com.subgraph.vega.api.scanner.IInjectionModuleContext;
import com.subgraph.vega.api.scanner.IPathState;
import com.subgraph.vega.impl.scanner.handlers.CrawlerModule;
import com.subgraph.vega.impl.scanner.handlers.InjectionChecks;
import org.apache.http.client.methods.HttpUriRequest;

public class PageVariabilityCheck
extends CrawlerModule {
    private static final int BH_CHECKS = 15;
    private final InjectionChecks injectionChecks;

    public PageVariabilityCheck(InjectionChecks injectionChecks) {
        this.injectionChecks = injectionChecks;
    }

    @Override
    public void initialize(IPathState iPathState) {
        IInjectionModuleContext iInjectionModuleContext = iPathState.createModuleContext();
        int n = 0;
        while (n < 15) {
            iInjectionModuleContext.submitRequest(iPathState.createRequest(), (ICrawlerResponseProcessor)this, n);
            ++n;
        }
    }

    @Override
    public void runModule(HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse, IInjectionModuleContext iInjectionModuleContext) {
        IPathState iPathState = iInjectionModuleContext.getPathState();
        if (iHttpResponse.isFetchFail()) {
            iInjectionModuleContext.error(httpUriRequest, iHttpResponse, "Failed to fetch response during page variability check");
        } else {
            this.testResponse(httpUriRequest, iHttpResponse, iInjectionModuleContext);
        }
        iInjectionModuleContext.incrementResponseCount();
        if (!iInjectionModuleContext.allResponsesReceived()) {
            return;
        }
        this.injectionChecks.launchInjectionModules(iPathState);
    }

    private void testResponse(HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse, IInjectionModuleContext iInjectionModuleContext) {
        IPageFingerprint iPageFingerprint = iHttpResponse.getPageFingerprint();
        IPathState iPathState = iInjectionModuleContext.getPathState();
        if (!iPathState.matchesPathFingerprint(iPageFingerprint)) {
            iPathState.setResponseVaries();
            iInjectionModuleContext.debug("Response varies");
        }
    }
}

