/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.handlers;

import com.subgraph.vega.api.crawler.ICrawlerResponseProcessor;
import com.subgraph.vega.api.crawler.IWebCrawler;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.api.scanner.IInjectionModuleContext;
import com.subgraph.vega.api.scanner.IPathState;
import com.subgraph.vega.impl.scanner.handlers.CaseSensitivityCheck;
import com.subgraph.vega.impl.scanner.handlers.InjectionChecks;
import com.subgraph.vega.impl.scanner.handlers.ParametricCheckHandler;
import com.subgraph.vega.impl.scanner.handlers.SecondaryExtChecks;
import org.apache.http.client.methods.HttpUriRequest;

public class FileProcessor
implements ICrawlerResponseProcessor {
    private final InjectionChecks injectionChecks = new InjectionChecks();
    private final SecondaryExtChecks secondaryExtChecks = new SecondaryExtChecks();
    private final ParametricCheckHandler parametricChecks = new ParametricCheckHandler();
    private final CaseSensitivityCheck caseCheck = new CaseSensitivityCheck();

    public void processResponse(IWebCrawler iWebCrawler, HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse, Object object) {
        boolean bl;
        IInjectionModuleContext iInjectionModuleContext = (IInjectionModuleContext)object;
        IPathState iPathState = iInjectionModuleContext.getPathState();
        iPathState.setResponse(iHttpResponse);
        iPathState.getPath().setVisited(true);
        if (iHttpResponse.isFetchFail()) {
            iInjectionModuleContext.error(httpUriRequest, iHttpResponse, "during initial file fetch");
            return;
        }
        IPathState iPathState2 = iPathState.get404Parent();
        boolean bl2 = bl = iPathState2 == null && iHttpResponse.getResponseCode() == 404 || iPathState2 != null && iPathState2.has404FingerprintMatching(iHttpResponse.getPageFingerprint());
        if (bl) {
            iPathState.setPageMissing();
        } else {
            IPathState iPathState3;
            if (iHttpResponse.getResponseCode() > 400) {
                iInjectionModuleContext.debug("Page is not accessible.  http code (" + iHttpResponse.getResponseCode() + ")");
            }
            if ((iPathState3 = iPathState.getParentState()) == null || iPathState3.getResponse() == null || !iPathState.matchesPathFingerprint(iPathState3.getPathFingerprint())) {
                iInjectionModuleContext.responseChecks(httpUriRequest, iHttpResponse);
            }
            if (iPathState2 != null && !iPathState.isParametric()) {
                this.secondaryExtChecks.initialize(iPathState);
            }
            if (iPathState.getPath().getPathType() == IWebPath.PathType.PATH_FILE) {
                this.caseCheck.initialize(iPathState);
            }
        }
        iPathState.unlockChildren();
        if (iPathState.isParametric()) {
            this.parametricChecks.initialize(iPathState);
        } else {
            this.injectionChecks.initialize(iPathState);
        }
    }

    public void processException(HttpUriRequest httpUriRequest, Throwable throwable, Object object) {
        IInjectionModuleContext iInjectionModuleContext = (IInjectionModuleContext)object;
        iInjectionModuleContext.reportRequestException(httpUriRequest, throwable);
    }
}

