/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.handlers;

import com.subgraph.vega.api.crawler.ICrawlerResponseProcessor;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.api.scanner.IInjectionModuleContext;
import com.subgraph.vega.api.scanner.IPathState;
import com.subgraph.vega.impl.scanner.handlers.CrawlerModule;
import com.subgraph.vega.impl.scanner.handlers.DirIPSCheck;
import org.apache.http.client.methods.HttpUriRequest;

public class DirParentCheck
extends CrawlerModule {
    private final DirIPSCheck ipsCheck = new DirIPSCheck();

    @Override
    public void initialize(IPathState iPathState) {
        if (!iPathState.has404Fingerprints() || !this.hasSuitablePath(iPathState)) {
            this.ipsCheck.initialize(iPathState);
            return;
        }
        IInjectionModuleContext iInjectionModuleContext = iPathState.createModuleContext();
        HttpUriRequest httpUriRequest = this.createRequest(iPathState);
        iInjectionModuleContext.submitRequest(httpUriRequest, (ICrawlerResponseProcessor)this, 0);
    }

    private boolean hasSuitablePath(IPathState iPathState) {
        IWebPath iWebPath = iPathState.getPath().getParentPath();
        return iWebPath != null && iWebPath.getParentPath() != null;
    }

    private HttpUriRequest createRequest(IPathState iPathState) {
        IWebPath iWebPath = iPathState.getPath();
        IWebPath iWebPath2 = iWebPath.getParentPath();
        String string = iWebPath2.getParentPath().getFullPath();
        String string2 = String.valueOf(string) + "foo/" + iWebPath.getPathComponent();
        return iPathState.getRequestEngine().createGetRequest(iWebPath.getHttpHost(), string2);
    }

    @Override
    public void runModule(HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse, IInjectionModuleContext iInjectionModuleContext) {
        IPathState iPathState = iInjectionModuleContext.getPathState();
        if (iHttpResponse.isFetchFail()) {
            iInjectionModuleContext.error(httpUriRequest, iHttpResponse, "Fetch failed during parent directory check");
        } else if (iPathState.matchesPathFingerprint(iHttpResponse.getPageFingerprint())) {
            iInjectionModuleContext.debug("Problem with parent directory behavior");
            iInjectionModuleContext.getPathState().setBadParentDirectory();
        }
        this.ipsCheck.initialize(iInjectionModuleContext.getPathState());
    }
}

