/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.handlers;

import com.subgraph.vega.api.crawler.ICrawlerResponseProcessor;
import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.scanner.IInjectionModuleContext;
import com.subgraph.vega.api.scanner.IPathState;
import com.subgraph.vega.impl.scanner.handlers.CrawlerModule;
import com.subgraph.vega.impl.scanner.handlers.InjectionChecks;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.HttpUriRequest;

public class DirIPSCheck
extends CrawlerModule {
    private static final String IPS_TEST = "_test1=c:\\windows\\system32\\cmd.exe&_test2=/etc/passwd&_test3=|/bin/sh&_test4=(SELECT * FROM nonexistent) --&_test5=>/no/such/file&_test6=<script>alert(1)</script>&_test7=javascript:alert(1)";
    private static final String IPS_SAFE = "_test1=ccddeeeimmnossstwwxy.:\\\\\\&_test2=acdepsstw//&_test3=bhins//&_test4=CEEFLMORSTeeinnnosttx-*&_test5=cefhilnosu///&_test6=acceiilpprrrssttt1)(&_test7=aaaceijlprrsttv1):(";
    private final InjectionChecks injection = new InjectionChecks();

    @Override
    public void initialize(IPathState iPathState) {
        IInjectionModuleContext iInjectionModuleContext = iPathState.createModuleContext();
        iInjectionModuleContext.submitRequest(this.createRequest(iPathState, IPS_TEST), (ICrawlerResponseProcessor)this, 0);
        iInjectionModuleContext.submitRequest(this.createRequest(iPathState, IPS_SAFE), (ICrawlerResponseProcessor)this, 1);
    }

    private HttpUriRequest createRequest(IPathState iPathState, String string) {
        IHttpRequestEngine iHttpRequestEngine = iPathState.getRequestEngine();
        HttpHost httpHost = iPathState.getPath().getHttpHost();
        String string2 = String.valueOf(iPathState.getPath().getFullPath()) + "?" + string;
        return iHttpRequestEngine.createGetRequest(httpHost, string2);
    }

    @Override
    public void runModule(HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse, IInjectionModuleContext iInjectionModuleContext) {
        IPathState iPathState = iInjectionModuleContext.getPathState();
        if (iInjectionModuleContext.hasModuleFailed()) {
            return;
        }
        if (iInjectionModuleContext.getCurrentIndex() == 1 && iHttpResponse.isFetchFail()) {
            iInjectionModuleContext.error(httpUriRequest, iHttpResponse, "Fetch failed during IPS tests");
            iInjectionModuleContext.setModuleFailed();
            this.injection.initialize(iPathState);
        }
        iInjectionModuleContext.addRequestResponse(httpUriRequest, iHttpResponse);
        iInjectionModuleContext.incrementResponseCount();
        if (!iInjectionModuleContext.allResponsesReceived()) {
            return;
        }
        IPathState iPathState2 = iPathState.get404Parent();
        if (iPathState2 == null || !iPathState2.isIPSDetected()) {
            if (iInjectionModuleContext.getSavedResponse(0).getResponseStatus() != IHttpResponse.ResponseStatus.RESPONSE_OK) {
                iInjectionModuleContext.debug("Possible IPS filter detected");
                iInjectionModuleContext.getPathState().setIPSDetected();
            } else if (!iInjectionModuleContext.isFingerprintMatch(0, 1)) {
                iInjectionModuleContext.debug("Possible IPS filter detected");
                iInjectionModuleContext.getPathState().setIPSDetected();
            }
        } else if (iInjectionModuleContext.getSavedResponse(0).getResponseStatus() == IHttpResponse.ResponseStatus.RESPONSE_OK && iInjectionModuleContext.isFingerprintMatch(0, 1)) {
            iInjectionModuleContext.debug("Previously detected IPS filter is no longer active");
        }
        this.injection.initialize(iPathState);
    }
}

