/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.handlers;

import com.subgraph.vega.api.crawler.ICrawlerResponseProcessor;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.http.requests.IPageFingerprint;
import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.api.scanner.IInjectionModuleContext;
import com.subgraph.vega.api.scanner.IPathState;
import com.subgraph.vega.impl.scanner.handlers.CaseSensitivityCheck;
import com.subgraph.vega.impl.scanner.handlers.CrawlerModule;
import com.subgraph.vega.impl.scanner.handlers.DirParentCheck;
import org.apache.http.client.methods.HttpUriRequest;

public class Dir404Tests
extends CrawlerModule {
    private static final String PAGE_DOES_NOT_EXIST = "nosuchpage123";
    private final DirParentCheck dirParentCheck = new DirParentCheck();
    private final CaseSensitivityCheck caseSensitivityCheck = new CaseSensitivityCheck();

    @Override
    public void initialize(IPathState iPathState) {
        IInjectionModuleContext iInjectionModuleContext = iPathState.createModuleContext();
        iInjectionModuleContext.submitAlteredRequest((ICrawlerResponseProcessor)this, "/nosuchpage123");
    }

    @Override
    public void runModule(HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse, IInjectionModuleContext iInjectionModuleContext) {
        IPathState iPathState = iInjectionModuleContext.getPathState();
        boolean bl = iInjectionModuleContext.getCurrentIndex() == 0;
        boolean bl2 = false;
        if (iPathState.hasFailed404Detection()) {
            bl2 = true;
        }
        if (iHttpResponse.isFetchFail()) {
            iInjectionModuleContext.error(httpUriRequest, iHttpResponse, "during 404 response checks");
            bl2 = true;
        }
        if (!bl2) {
            this.processResponseFingerprint(iInjectionModuleContext, httpUriRequest, iHttpResponse, bl);
            if (bl) {
                this.finishProcessingFirstResponse(iInjectionModuleContext, iPathState);
            }
        }
        this.finishProcessingResponse(iInjectionModuleContext, iPathState);
    }

    private void finishProcessingResponse(IInjectionModuleContext iInjectionModuleContext, IPathState iPathState) {
        iInjectionModuleContext.incrementResponseCount();
        if (!iInjectionModuleContext.allResponsesReceived()) {
            return;
        }
        if (!iPathState.has404Fingerprints() || iPathState.hasFailed404Detection()) {
            this.handleFailed404Detection(iInjectionModuleContext, iPathState);
        }
        this.dirParentCheck.initialize(iPathState);
    }

    private void finishProcessingFirstResponse(IInjectionModuleContext iInjectionModuleContext, IPathState iPathState) {
        if (!iPathState.has404Fingerprints()) {
            iInjectionModuleContext.debug("First 404 probe failed to produce a signature");
        } else {
            iInjectionModuleContext.pivotChecks(iPathState.createRequest(), iPathState.getResponse());
            this.caseSensitivityCheck.initialize(iPathState);
            this.scheduleProbes(iInjectionModuleContext);
        }
    }

    private void processResponseFingerprint(IInjectionModuleContext iInjectionModuleContext, HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse, boolean bl) {
        IPageFingerprint iPageFingerprint = iHttpResponse.getPageFingerprint();
        IPathState iPathState = iInjectionModuleContext.getPathState();
        if (bl && !iPathState.isSureDirectory() && !iPathState.isRootPath() && iPathState.matchesPathFingerprint(iPageFingerprint)) {
            iInjectionModuleContext.debug("First 404 probe identical to parent page");
            return;
        }
        if (!iPathState.add404Fingerprint(iPageFingerprint)) {
            iInjectionModuleContext.debug("Failed 404 detection, too many unique 404 signatures received");
            iPathState.setFailed404Detection();
            return;
        }
        IPathState iPathState2 = iPathState.get404Parent();
        if (iPathState2 != null && !iPathState2.has404FingerprintMatching(iPageFingerprint)) {
            iInjectionModuleContext.debug("New 404 signature detected that was not detected on parent");
            iInjectionModuleContext.responseChecks(httpUriRequest, iHttpResponse);
        }
    }

    private void scheduleProbes(IInjectionModuleContext iInjectionModuleContext) {
        for (String string : iInjectionModuleContext.getFileExtensionList()) {
            iInjectionModuleContext.submitAlteredRequest((ICrawlerResponseProcessor)this, "nosuchpage123." + string, 1);
        }
        iInjectionModuleContext.submitAlteredRequest((ICrawlerResponseProcessor)this, "lpt9", 1);
        iInjectionModuleContext.submitAlteredRequest((ICrawlerResponseProcessor)this, "~nosuchpage123", 1);
        iInjectionModuleContext.submitAlteredRequest((ICrawlerResponseProcessor)this, PAGE_DOES_NOT_EXIST, 1);
    }

    private void handleFailed404Detection(IInjectionModuleContext iInjectionModuleContext, IPathState iPathState) {
        IPathState iPathState2;
        int n;
        int n2 = n = iPathState.getResponse() == null ? 0 : iPathState.getResponse().getResponseCode();
        if (n == 404) {
            iPathState.setPageMissing();
        } else if (n > 400) {
            this.logFailureMessage(iInjectionModuleContext, n);
        } else if (!iPathState.isRootPath()) {
            iPathState.getPath().setPathType(IWebPath.PathType.PATH_PATHINFO);
        } else {
            iInjectionModuleContext.debug("No distinctive 404 signatures detected");
        }
        iPathState.clear404Fingerprints();
        if (iPathState.getParentState() == null || iPathState.getParentState().getResponse() == null) {
            iInjectionModuleContext.pivotChecks(iPathState.createRequest(), iPathState.getResponse());
            return;
        }
        if (!(iPathState.getParentState().matchesPathFingerprint(iPathState.getPathFingerprint()) || (iPathState2 = iPathState.get404Parent()) != null && iPathState2.has404FingerprintMatching(iPathState.getPathFingerprint()))) {
            iInjectionModuleContext.pivotChecks(iPathState.createRequest(), iPathState.getResponse());
        }
    }

    private void logFailureMessage(IInjectionModuleContext iInjectionModuleContext, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Directory resource is not accessible: HTTP response code (");
        stringBuilder.append(n);
        stringBuilder.append(")");
        if (n == 401) {
            stringBuilder.append(" [HTTP Auth required");
        }
        if (n >= 500) {
            stringBuilder.append(" [Server error]");
        }
        iInjectionModuleContext.debug(stringBuilder.toString());
    }
}

