/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.forms;

import com.subgraph.vega.api.html.IHTMLParseResult;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.scanner.IInjectionModuleContext;
import com.subgraph.vega.api.scanner.IPathState;
import com.subgraph.vega.api.scanner.IScannerConfig;
import com.subgraph.vega.api.util.VegaURI;
import com.subgraph.vega.impl.scanner.forms.FormProcessingState;
import com.subgraph.vega.impl.scanner.urls.UriFilter;
import com.subgraph.vega.impl.scanner.urls.UriParser;
import java.net.URI;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLDocument;

public class FormProcessor {
    private final IScannerConfig config;
    private final UriFilter uriFilter;
    private final UriParser uriParser;

    public FormProcessor(IScannerConfig iScannerConfig, UriFilter uriFilter, UriParser uriParser) {
        this.config = iScannerConfig;
        this.uriFilter = uriFilter;
        this.uriParser = uriParser;
    }

    public void processForms(IInjectionModuleContext iInjectionModuleContext, HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse) {
        IHTMLParseResult iHTMLParseResult = iHttpResponse.getParsedHTML();
        if (iHTMLParseResult == null) {
            return;
        }
        HTMLDocument hTMLDocument = iHTMLParseResult.getDOMDocument();
        HTMLCollection hTMLCollection = hTMLDocument.getForms();
        int n = 0;
        while (n < hTMLCollection.getLength()) {
            Node node = hTMLCollection.item(n);
            if (node instanceof Element) {
                this.processFormElement(iInjectionModuleContext, httpUriRequest, (Element)node);
            }
            ++n;
        }
    }

    private void processFormElement(IInjectionModuleContext iInjectionModuleContext, HttpUriRequest httpUriRequest, Element element) {
        URI uRI = httpUriRequest.getURI();
        HttpHost httpHost = URIUtils.extractHost((URI)uRI);
        VegaURI vegaURI = new VegaURI(httpHost, uRI.getPath(), uRI.getQuery());
        FormProcessingState formProcessingState = new FormProcessingState(vegaURI, element.getAttribute("action"), element.getAttribute("method"), this.config.getFormCredentials());
        if (!formProcessingState.isValid()) {
            return;
        }
        NodeList nodeList = element.getElementsByTagName("*");
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                this.processSingleFormElement(formProcessingState, (Element)node);
            }
            ++n;
        }
        if (formProcessingState.getFileFieldFlag()) {
            iInjectionModuleContext.debug("Cannot process form because file input handling not implemented");
            return;
        }
        iInjectionModuleContext.debug("Processed form: " + formProcessingState);
        this.submitNewForm(formProcessingState);
    }

    private void submitNewForm(FormProcessingState formProcessingState) {
        if (!this.uriFilter.isAllowed(formProcessingState.getTargetURI())) {
            return;
        }
        IPathState iPathState = this.uriParser.processUri(formProcessingState.getTargetURI());
        if (formProcessingState.isPostMethod()) {
            iPathState.maybeAddPostParameters(formProcessingState.getParameters());
        } else {
            iPathState.maybeAddParameters(formProcessingState.getParameters());
        }
    }

    private void processSingleFormElement(FormProcessingState formProcessingState, Element element) {
        if (element.getTagName().toLowerCase().equals("input")) {
            this.processInputElement(formProcessingState, element);
        } else {
            this.processOtherFormElement(formProcessingState, element);
        }
    }

    private void processInputElement(FormProcessingState formProcessingState, Element element) {
        String string = this.decodeAttribute(element, "name");
        if (string == null) {
            return;
        }
        String string2 = element.getAttribute("type");
        String string3 = string2 == null ? "text" : string2.toLowerCase();
        String string4 = this.decodeAttribute(element, "value");
        if (string3.equals("file")) {
            formProcessingState.setFileFieldFlag();
            return;
        }
        if (string3.equals("checkbox")) {
            formProcessingState.add(string, "on");
        } else if (string3.equals("hidden") && string4 != null && !string4.isEmpty()) {
            formProcessingState.add(string, string4);
        } else if (!string3.equals("reset")) {
            if (string4 != null && !string4.isEmpty()) {
                formProcessingState.add(string, string4);
            } else {
                formProcessingState.addGuessedValue(string);
            }
        }
        if (string3.equals("password")) {
            formProcessingState.setPasswordFieldFlag();
        }
    }

    private void processOtherFormElement(FormProcessingState formProcessingState, Element element) {
        String string = element.getTagName().toLowerCase();
        if (string.equals("textarea") || string.equals("select") || string.equals("button")) {
            String string2 = this.decodeAttribute(element, "name");
            if (string2 == null) {
                return;
            }
            String string3 = this.decodeAttribute(element, "value");
            if (string3 == null || string3.isEmpty()) {
                formProcessingState.addGuessedValue(string2);
            } else {
                formProcessingState.add(string2, string3);
            }
        }
    }

    private String decodeAttribute(Element element, String string) {
        String string2 = element.getAttribute(string);
        if (string2 == null) {
            return null;
        }
        return string2;
    }
}

