/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner;

import com.subgraph.vega.api.analysis.IContentAnalyzer;
import com.subgraph.vega.api.crawler.IWebCrawler;
import com.subgraph.vega.api.http.requests.IHttpMacroContext;
import com.subgraph.vega.api.http.requests.IHttpMacroExecutor;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.api.model.identity.IAuthMethod;
import com.subgraph.vega.api.model.identity.IAuthMethodHttpMacro;
import com.subgraph.vega.api.model.identity.IIdentity;
import com.subgraph.vega.api.model.scope.ITargetScope;
import com.subgraph.vega.api.scanner.modules.IScannerModule;
import com.subgraph.vega.api.scanner.modules.IScannerModuleRunningTime;
import com.subgraph.vega.api.util.VegaURI;
import com.subgraph.vega.impl.scanner.Scan;
import com.subgraph.vega.impl.scanner.urls.UriFilter;
import com.subgraph.vega.impl.scanner.urls.UriParser;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.utils.URIUtils;

public class ScannerTask
implements Runnable {
    private final Logger logger = Logger.getLogger("scanner");
    private final Scan scan;
    private final IScanInstance scanInstance;
    private IContentAnalyzer contentAnalyzer;
    private final UriParser uriParser;
    private final UriFilter uriFilter;
    private final ITargetScope scanTargetScope;
    private volatile boolean stopRequested;
    private IWebCrawler currentCrawler;

    ScannerTask(Scan scan) {
        this.scan = scan;
        this.scanInstance = scan.getScanInstance();
        this.currentCrawler = scan.getScanner().getWebCrawlerFactory().create(scan.getRequestEngine());
        this.contentAnalyzer = scan.getScanner().getContentAnalyzerFactory().createContentAnalyzer(this.scanInstance);
        this.contentAnalyzer.setResponseProcessingModules(scan.getResponseModules());
        this.uriFilter = new UriFilter(scan.getConfig());
        this.uriParser = new UriParser(scan.getConfig(), scan.getBasicModules(), scan.getWorkspace(), this.currentCrawler, this.uriFilter, this.contentAnalyzer, this.scanInstance, false);
        this.scanTargetScope = scan.getConfig().getScanTargetScope();
        this.logger.setLevel(Level.ALL);
    }

    void stop() {
        this.stopRequested = true;
        if (this.currentCrawler != null) {
            try {
                this.currentCrawler.stop();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        this.scanInstance.updateScanStatus(3);
        this.scan.getRequestEngine().getCookieStore().clear();
        if (this.handleMacroAuthentication()) {
            this.runCrawlerPhase();
            if (this.stopRequested) {
                this.scanInstance.updateScanStatus(5);
                this.logger.info("Scanner cancelled");
            } else {
                this.scanInstance.updateScanStatus(4);
                this.logger.info("Scanner completed");
            }
        }
        this.scan.doFinish();
        this.printModuleRuntimeStats();
    }

    private void printModuleRuntimeStats() {
        IScannerModuleRunningTime iScannerModuleRunningTime;
        this.logger.info("Scanning module runtime statistics:");
        for (IScannerModule iScannerModule : this.scan.getResponseModules()) {
            iScannerModuleRunningTime = iScannerModule.getRunningTimeProfile();
            if (iScannerModuleRunningTime.getInvocationCount() <= 0) continue;
            this.logger.info(iScannerModuleRunningTime.toString());
        }
        for (IScannerModule iScannerModule : this.scan.getBasicModules()) {
            iScannerModuleRunningTime = iScannerModule.getRunningTimeProfile();
            if (iScannerModuleRunningTime.getInvocationCount() <= 0) continue;
            this.logger.info(iScannerModuleRunningTime.toString());
        }
    }

    private boolean handleMacroAuthentication() {
        IAuthMethod iAuthMethod;
        IIdentity iIdentity = this.scan.getConfig().getScanIdentity();
        if (iIdentity != null && (iAuthMethod = iIdentity.getAuthMethod()) != null && iAuthMethod.getType() == IAuthMethod.AuthMethodType.AUTH_METHOD_HTTP_MACRO) {
            this.logger.info("Pre-authenticating using an HTTP macro");
            IAuthMethodHttpMacro iAuthMethodHttpMacro = (IAuthMethodHttpMacro)iAuthMethod;
            IHttpMacroContext iHttpMacroContext = this.scan.getRequestEngine().createMacroContext();
            iHttpMacroContext.setDict(iIdentity.getDict());
            IHttpMacroExecutor iHttpMacroExecutor = this.scan.getRequestEngine().createMacroExecutor(iAuthMethodHttpMacro.getMacro(), iHttpMacroContext);
            while (iHttpMacroExecutor.hasNext()) {
                IHttpResponse iHttpResponse;
                try {
                    iHttpResponse = iHttpMacroExecutor.sendNextRequest().get(true);
                }
                catch (Exception exception) {
                    this.logger.log(Level.WARNING, exception.getMessage());
                    return false;
                }
                this.contentAnalyzer.processResponse(iHttpResponse, true, false);
                int n = iHttpResponse.getResponseCode();
                if (n != 301 && n != 302 && n != 303 && n != 307) continue;
                Header header = iHttpResponse.getRawResponse().getFirstHeader("Location");
                if (header == null) {
                    return false;
                }
                VegaURI vegaURI = VegaURI.fromHostAndRequest((HttpHost)iHttpResponse.getHost(), (HttpRequest)iHttpResponse.getOriginalRequest());
                VegaURI vegaURI2 = vegaURI.resolve(header.getValue());
                if (!this.uriFilter.filter(vegaURI2)) continue;
                this.uriParser.processUri(vegaURI2);
            }
        }
        return true;
    }

    private void runCrawlerPhase() {
        this.logger.info("Starting crawling phase");
        for (URI uRI : this.scanTargetScope.getScopeURIs()) {
            this.uriParser.processUri(this.toVegaURI(uRI));
        }
        this.currentCrawler.start();
        try {
            this.currentCrawler.waitFinished();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.currentCrawler = null;
        this.logger.info("Crawler finished");
    }

    private VegaURI toVegaURI(URI uRI) {
        HttpHost httpHost = URIUtils.extractHost((URI)uRI);
        return new VegaURI(httpHost, uRI.getPath(), uRI.getQuery());
    }

    void pauseScan() {
        IWebCrawler iWebCrawler = this.currentCrawler;
        if (iWebCrawler != null) {
            iWebCrawler.pause();
            this.scanInstance.notifyScanPauseState(true);
        }
    }

    void unpauseScan() {
        IWebCrawler iWebCrawler = this.currentCrawler;
        if (iWebCrawler != null) {
            iWebCrawler.unpause();
            this.scanInstance.notifyScanPauseState(false);
        }
    }

    boolean isPaused() {
        IWebCrawler iWebCrawler = this.currentCrawler;
        if (iWebCrawler != null) {
            return iWebCrawler.isPaused();
        }
        return false;
    }
}

